% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_holiday.R
\name{infer_holiday}
\alias{infer_holiday}
\title{Infer if a date is a fedral holiday}
\usage{
infer_holiday(date_lst)
}
\arguments{
\item{date_lst}{a list of dates strings of the format YYYY-MM-DD}
}
\value{
Returns the kind of fedral holiday that was/will be observed on that date. If there was no holiday observed, it returns None.
It does the lookup in parallel and hence is very fast.
}
\description{
A function that returns the federal holiday observed on a given date. If there was no holiday observed, it returns None. The function takes in a list of dates, where each date is in the format YYYY-MM-DD and checks them against a database of federal holidays (2012-2020). It returns the holiday that was/will be observed on the date. If no holiday is observed on that date, it returns "None" corresponding to that date. This computation happens in parallel and hence is very fast.
}
\examples{
infer_holiday(date_lst = c("2020-12-25", "2020-09-07", "2020-09-08", "2016-01-18",
 "2016-01-19", "2016-01-15"))
}
