% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.R
\name{ampbox_data}
\alias{ampbox_data}
\title{Amplitude Boxplot Data}
\usage{
ampbox_data(warp_median, alpha = 0.05, ka = 1)
}
\arguments{
\item{warp_median}{fdawarp object from \code{\link[=time_warping]{time_warping()}} of aligned data using
the median}

\item{alpha}{quantile value (default=.05, i.e., 95\%)}

\item{ka}{scalar for outlier cutoff (default=1)}
}
\value{
Returns an \code{ampbox} object containing:
\itemize{
\item \code{median_y}: median function
\item \code{Q1}: First quartile
\item \code{Q3}: Second quartile
\item \code{Q1a}: First quantile based on alpha
\item \code{Q3a}: Second quantile based on alpha
\item \code{minn}: minimum extreme function
\item \code{maxx}: maximum extreme function
\item \code{outlier_index}: indexes of outlier functions
\item \code{fmedian}: median function
}
}
\description{
This function constructs the amplitude boxplot.
}
\references{
Xie, W., S. Kurtek, K. Bharath, and Y. Sun  (2016). "A geometric
approach to visualization of variability in functional data." Journal of
the American Statistical Association in press: 1-34.
}
\keyword{alignment}
\keyword{boxplot}
\keyword{internal}
\keyword{srvf}
