% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_shapes.R
\name{sample_shapes}
\alias{sample_shapes}
\title{Sample shapes from model}
\usage{
sample_shapes(x, no = 3, numSamp = 10)
}
\arguments{
\item{x}{An object of class \code{fdacurve} typically produced by \code{\link[=curve_srvf_align]{curve_srvf_align()}}}

\item{no}{number of principal components}

\item{numSamp}{number of samples}
}
\value{
Returns a \code{fdacurve} object containing \item{betans}{random aligned curves}
\item{qns}{random aligned srvfs}
\item{betans}{random curves}
\item{qs}{random srvfs}
\item{gams}{random reparametrization functions}
\item{R}{random rotation matrices}
}
\description{
Sample shapes from model
}
\examples{
out <- curve_srvf_align(beta[, , 1, 1:5], maxit = 2, parallel=FALSE)
# note: use more shapes, small for speed
out.samples <- sample_shapes(out)
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape
analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine
Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
