% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_align_functions.R
\name{pair_align_functions}
\alias{pair_align_functions}
\title{Align two functions}
\usage{
pair_align_functions(
  f1,
  f2,
  time,
  lambda = 0,
  pen = "roughness",
  method = "DP",
  w = 0.01,
  iter = 2000
)
}
\arguments{
\item{f1}{function 1}

\item{f2}{function 2}

\item{time}{sample points of functions}

\item{lambda}{controls amount of warping (default = 0)}

\item{pen}{alignment penalty (default="roughness") options are
second derivative ("roughness"), geodesic distance from id ("geodesic"), and
norm from id ("norm")}

\item{method}{controls which optimization method (default="DP") options are
Dynamic Programming ("DP"), Coordinate Descent ("DP2"), Riemannian BFGS
("RBFGS"), Simultaneous Alignment ("SIMUL"), Dirichlet Bayesian ("dBayes"),
and Expo-Map Bayesian ("expBayes")}

\item{w}{controls LRBFGS (default = 0.01)}

\item{iter}{number of mcmc iterations for mcmc method (default 2000)}
}
\value{
Returns a list containing \item{f2tilde}{aligned f2}
\item{gam}{warping function}
}
\description{
This function aligns two functions using SRSF framework. It will align f2
to f1
}
\examples{
out <- pair_align_functions(
  f1 = simu_data$f[, 1],
  f2 = simu_data$f[, 2],
  time = simu_data$time
)
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
May 2011. Registration of functional data using fisher-rao metric,
arXiv:1103.3817v2.

Tucker, J. D., Wu, W., Srivastava, A.,
Generative Models for Function Data using Phase and Amplitude Separation,
Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.

Cheng, W., Dryden, I. L., and Huang, X. (2016). Bayesian
registration of functions and curves. Bayesian Analysis, 11(2), 447-475.

Lu, Y., Herbei, R., and Kurtek, S. (2017). Bayesian registration
of functions with a Gaussian process prior. Journal of Computational and
Graphical Statistics, DOI: 10.1080/10618600.2017.1336444.
}
\keyword{alignment}
\keyword{srsf}
