% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testFunctions.R
\name{fs.test}
\alias{fs.test}
\title{FELSPLINE test function}
\usage{
fs.test(x, y, r0 = 0.1, r = 0.5, l = 3, b = 1)
}
\arguments{
\item{x, y}{Points at which to evaluate the test function.}

\item{r0}{The test domain is a sort of bent sausage. This is the radius of the inner bend.}

\item{r}{The radius of the curve at the centre of the sausage.}

\item{l}{The length of an arm of the sausage.}

\item{b}{The rate at which the function increases per unit increase in distance along the centre line of the sausage.}
}
\value{
Returns function evaluations, or NAs for points outside the horseshoe domain.
}
\description{
Implements a finite area test function based on one proposed by Tim Ramsay (2002) proposed by 
Simon Wood (2008).
}
\examples{
library(fdaPDE)

## Upload the horseshoe2D data
data(horseshoe2D)
boundary_nodes = horseshoe2D$boundary_nodes
boundary_segments = horseshoe2D$boundary_segments
locations = horseshoe2D$locations

## Create the 2D mesh
mesh = create.mesh.2D(nodes = rbind(boundary_nodes, locations), segments = boundary_segments)
## Create the FEM basis
FEMbasis = create.FEM.basis(mesh)
## Compute the coeff vector evaluating the desired function at the mesh nodes
## In this case we consider the fs.test() function introduced by Wood et al. 2008
coeff = fs.test(mesh$nodes[,1], mesh$nodes[,2])
## Create the FEM object
FEMfunction = FEM(coeff, FEMbasis)
## Plot it
plot(FEMfunction)
}
\references{
\itemize{
   \item{Ramsay, T. 2002. Spline smoothing over difficult regions. J.R.Statist. Soc. B 64(2):307-319}
   \item{Wood, S. N., Bravington, M. V., & Hedley, S. L. (2008). Soap film smoothing. Journal of the Royal 
Statistical Society: Series B (Statistical Methodology), 70(5), 931-955.}
}
}
