\name{eval.surp}
\alias{eval.surp}
\title{Values of a Functional Data Object Defining Surprisal Curves.}
\description{
A surprisal vector of length \code{M} is minus the log to a positive integer 
base \code{M} of a set of \code{M} multinomial probabilities.  Surprisal
curves are functions of a one-dimensional index set, such that at any
value of the index set the values of the curves are a surprisal vector.
See Details below for further explanations.
}
\usage{
eval.surp(evalarg, Wfdobj, nderiv = 0)
}
\arguments{
  \item{evalarg}{a vector or matrix of argument values at which the functional data
    object is to be evaluated.}
  \item{Wfdobj}{a functional data object of dimension \code{M-1} to be evaluated.}
  \item{nderiv}{An integer defining a derivatve of \code{Wfdobj} in
  the set \code{c(0,1,2)}.}
}
\details{A surprisal \code{M}-vector is information measured in \code{M}-bits.
Since a multinomial probability vector must sum to one, it follows 
that the surprisal vector \code{S} must satisfy the constraint 
\code{log_M(sum(M^(-S)) = 0.} That is, surprisal vectors lie within a
curved \code{M-1}-dimensional manifold.

Surprisal curves are defined by a set of unconstrained \code{M-1} B-spline 
functional data objects defined over an index set that are transformed into 
surprisal curves defined over the index set.  

Let \code{C} be a \code{K} by \code{M-1} coefficient matrix defining the 
B-spline curves, where \code{K} is the number of B-spline basis functions.  

Let a \code{M} by \code{M-1} matrix \code{Z} have orthonormal columns.
Matrices satisfying these constraints are generated by function 
\code{zerobasis()}.  

Let \code{N} by \code{K} matrix be a matrix of B-spline basis values
evaluated at \code{N} evaluation points using function 
\code{eval.basis()}.

Let \code{N} by \code{M} matrix \code{X} = \code{B * C * t(Z)}. 

Then the \code{N} by \code{M} matrix \code{S} of surprisal values is
\code{S} = \code{-X + outer(log(rowSums(M^X))/log(M),rep(1,M))}.
}
\value{
A  \code{N} by \code{M} matrix \code{S} of surprisal values at points
\code{evalarg}, or their first or second derivatives.}
\references{
Ramsay, J. O., Li J. and Wiberg, M. (2020) Full information optimal scoring. 
Journal of Educational and Behavioral Statistics, 45, 297-315.

Ramsay, J. O., Li J. and Wiberg, M. (2020) Better rating scale scores with information-based 
psychometrics.  Psych, 2, 347-360.

http://testgardener.azurewebsites.net
}
\author{Juan Li and James Ramsay}
\seealso{
  \code{\link{smooth.surp}}
}
\examples{
#  see example in man/smooth.surp.Rd
}