% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fb_insights.R
\name{fb_insights}
\alias{fb_insights}
\title{Insights}
\usage{
fb_insights(fbacc, target = fbacc$acct_path, job_type = c("sync", "async"),
  retries = 0, ...)
}
\arguments{
\item{fbacc}{(optional) \code{FB_Ad_account} object, which defaults to the last returned object of \code{\link{fbad_init}}.}

\item{target}{ad account id(s) (default), campaign id(s), adset id(s) or ad id(s)}

\item{job_type}{synchronous or asynchronous request. If the prior fails with "please reduce the amount of data", it will fall back to async request. Async query is possible with only one target.}

\item{retries}{number of times this query has been sent to Facebook previously and failed -- to be used internally for error handling}

\item{...}{named arguments passed to the API, like time range, fields, filtering etc.}
}
\value{
list
}
\description{
Insights
}
\examples{
\dontrun{
fb_insights(fbacc)

## process results
l <- fb_insights(fbacc, date_preset = 'today', level = 'ad')
library(rlist)
list.stack(list.select(l, date_start, date_stop, ad_id, total_actions,
  total_unique_actions, total_action_value, impressions, unique_impressions,
  social_impressions, unique_social_impressions, clicks, unique_clicks,
  social_clicks, unique_social_clicks, spend, frequency, deeplink_clicks,
  app_store_clicks, website_clicks, reach, social_reach, ctr, unique_ctr,
  cpc, cpm, cpp, cost_per_total_action, cost_per_unique_click,
  relevance_score = relevance_score$score))
}
}
\references{
\url{https://developers.facebook.com/docs/marketing-api/insights/v2.5}
}

