% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from.edgelist.R
\name{from.edgelist}
\alias{from.edgelist}
\title{Edgelist to \code{fastnet}}
\usage{
from.edgelist(edgelist)
}
\arguments{
\item{edgelist}{A 2-column data frame, in which the 1st column represents the start nodes, and the 2nd column represents the destination nodes.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Transform an edgelist to an ego-centric list form used in \code{fastnet}.
}
\details{
Most network data repositories choose to store the data in an edgelist form. This function helps user to load it in \code{fastnet}.
}
\examples{
edgelist <- data.frame(from=c(1, 3, 2, 3, 3), to=c(4, 5, 6, 5, 7))
g <- from.edgelist(edgelist)
}
\author{
Xu Dong
}
