% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.random.plc.R
\name{net.random.plc}
\alias{net.random.plc}
\title{Random Network with a Power-law Degree Distribution that Has An Exponential Cutoff}
\usage{
net.random.plc(n, cutoff, exponent)
}
\arguments{
\item{n}{The number of the nodes in the network.}

\item{cutoff}{Exponential cutoff of the degree distribution of the network.}

\item{exponent}{Exponent of the degree distribution of the network.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Simulate a random network with a power-law degree distribution that has an exponential cutoff, according to Newman et al. (2001).
}
\details{
The generated random network has a power-law degree distribution with an exponential degree cutoff.
}
\examples{
\dontrun{
x <- net.random.plc(1000, 10, 2)}
}
\references{
Newman, Mark EJ, Steven H. Strogatz, and Duncan J. Watts. "Random graphs with arbitrary degree distributions and their applications." Physical review E 64, no. 2 (2001): 026118.
}
\author{
Xu Dong, Nazrul Shaikh
}
