% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logrank_test.R
\name{multi_logrank_test}
\alias{multi_logrank_test}
\title{Calculate multiple Log-Rank-Tests very fast}
\usage{
multi_logrank_test(
  groupas,
  groupbs,
  groupacensoreds,
  groupbcensoreds,
  threadnumber = NULL,
  onlyz = FALSE
)
}
\arguments{
\item{groupas}{list of vectors of groupa's survival times}

\item{groupbs}{list of vectors of groupb's survival times}

\item{groupacensoreds}{list of vectors of censored information of groupa's survival times}

\item{groupbcensoreds}{list of vectors of censored information of groupb's survival times}

\item{threadnumber}{(optional) set the number of threads used for this function}

\item{onlyz}{(optional) calculate only z-statistic}
}
\value{
vector of chi2 statistic, z-statistic, p-value (same order as input)
}
\description{
Calculate multiple Log-Rank-Tests very fast
}
\examples{
T1 <- c(6, 6, 6, 6, 7, 9, 10, 10, 11, 13, 16, 17, 19, 20, 22, 23, 25, 32, 32, 34, 35)
E1 <- c(1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0)
T2 <- c(1, 1, 2, 2, 3, 4, 4, 5, 5, 8, 8, 8, 8, 11, 11, 12, 12, 15, 17, 22, 23)
E2 <- c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
t1s<-list(T1, T1, T1)
e1s<-list(E1, E1, E1)
t2s<-list(T2, T2, T2)
e2s<-list(E2, E2, E2)
multi_logrank_test(t1s, t2s, e1s, e2s)
#1.679294e+01 -4.097919e+00 4.168809e-05 1.679294e+01 -4.097919e+00 4.168809e-05
#1.679294e+01 -4.097919e+00 4.168809e-05
}
