% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd.R
\name{fastcpd_poisson}
\alias{fastcpd_poisson}
\alias{fastcpd.poisson}
\title{Find change points efficiently in Poisson regression models}
\usage{
fastcpd_poisson(data, ...)

fastcpd.poisson(data, ...)
}
\arguments{
\item{data}{A matrix or a data frame with the response variable as the first
column.}

\item{...}{Other arguments passed to \code{\link[=fastcpd]{fastcpd()}}, for example,
\code{segment_count}.}
}
\value{
A \linkS4class{fastcpd} object.
}
\description{
\code{\link[=fastcpd_poisson]{fastcpd_poisson()}} and \code{\link[=fastcpd.poisson]{fastcpd.poisson()}} are
wrapper functions of \code{\link[=fastcpd]{fastcpd()}} to find change points in
Poisson regression models. The function is similar to \code{\link[=fastcpd]{fastcpd()}}
except that the data is by default a matrix or data frame with the response
variable as the first column and thus a formula is not required here.
}
\examples{
\donttest{
if (requireNamespace("mvtnorm", quietly = TRUE)) {
  set.seed(1)
  n <- 1100
  p <- 3
  x <- mvtnorm::rmvnorm(n, rep(0, p), diag(p))
  delta <- rnorm(p)
  theta_0 <- c(1, 0.3, -1)
  y <- c(
    rpois(500, exp(x[1:500, ] \%*\% theta_0)),
    rpois(300, exp(x[501:800, ] \%*\% (theta_0 + delta))),
    rpois(200, exp(x[801:1000, ] \%*\% theta_0)),
    rpois(100, exp(x[1001:1100, ] \%*\% (theta_0 - delta)))
  )
  result <- fastcpd.poisson(cbind(y, x))
  summary(result)
  plot(result)
}
}
}
\seealso{
\code{\link[=fastcpd]{fastcpd()}}
}
