% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy_rows.R
\name{dummy_rows}
\alias{dummy_rows}
\title{Fast creation of dummy rows}
\usage{
dummy_rows(data, select_columns = NULL, dummy_value = NA,
  dummy_indicator = FALSE)
}
\arguments{
\item{data}{An object with the data set you want to make dummy columns from.}

\item{select_columns}{If NULL (default), uses all character, factor, and Date columns to produce categories
to make the dummy rows by. If not NULL, you manually enter a string or vector of strings of columns name(s).}

\item{dummy_value}{Value of the row for columns that are not selected.
Default is a value of 0.}

\item{dummy_indicator}{Adds binary column to say if row is dummy or not (i.e. included in
original data or not)}
}
\value{
A data.frame with same number of columns as inputted data and original
rows plus the newly created dummy rows
}
\description{
dummy_rows() quickly creates dummy rows to fill in missing rows
based on all combinations of available character, factor, and
date columns (if not otherwise specified). This is useful for
creating balanced panel data. Columns that are not character,
factor, or dates are filled in with NA (or whatever value you
specify).
}
\examples{
crime <- data.frame(city = c("SF", "SF", "NYC"),
    year = c(1990, 2000, 1990),
    crime = 1:3)

dummy_rows(crime)
# Include year column
dummy_rows(crime, select_columns = c("city", "year"))
# m=Make dummy value 0
dummy_rows(crime, select_columns = c("city", "year"),
    dummy_value = 0)
# Add a dummy indicator
dummy_rows(crime, select_columns = c("city", "year"),
    dummy_indicator = TRUE)
}
\seealso{
\code{\link{dummy_cols}} For creating dummy columns

Other dummy functions: \code{\link{dummy_cols}},
  \code{\link{dummy_columns}}
}
