% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_adaboost.R
\name{predict.real_adaboost}
\alias{predict.real_adaboost}
\title{predict method for real_adaboost objects}
\usage{
\method{predict}{real_adaboost}(object, newdata, ...)
}
\arguments{
\item{object}{an object of class real_adaboost}

\item{newdata}{dataframe on which we are looking to predict}

\item{...}{arguments passed to predict.default}
}
\value{
predicted object, which is a list with the following components
\item{formula}{the formula used.}
\item{votes}{total weighted votes achieved by each class}
\item{class}{the class predicted by the classifier}
\item{prob}{a matrix with predicted probability of each class for each observation}
\item{error}{The error on the test data if labeled, otherwise \code{NA}}
}
\description{
predictions for model corresponding to real_adaboost algorithm
}
\details{
makes predictions for an adaboost object on a new dataset
using the real_adaboost algorithm.
The target variable is not required 
for the prediction to work.
However, the user must ensure that the test data has the same 
columns which were used as inputs to fit the original model.
The error component of the prediction object(as in 
\code{pred$error}) can be used to get the error of the 
test set if the test data is labeled.
}
\examples{
fakedata <- data.frame( X=c(rnorm(100,0,1),rnorm(100,1,1)), Y=c(rep(0,100),rep(1,100) ) )
fakedata$Y <- factor(fakedata$Y)
test_real_adaboost <- real_adaboost(Y~X, fakedata, 10)
pred <- predict(test_real_adaboost,newdata=fakedata)
print(pred$error)
print( table(pred$class,fakedata$Y) )

}
\seealso{
\code{\link{real_adaboost}}
}

