/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.inference;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.FDistributionImpl;
import org.apache.commons.math.stat.descriptive.summary.Sum;
import org.apache.commons.math.stat.descriptive.summary.SumOfSquares;
import org.apache.commons.math.stat.inference.OneWayAnova;

public class OneWayAnovaImpl
implements OneWayAnova {
    public double anovaFValue(Collection categoryData) throws IllegalArgumentException, MathException {
        AnovaStats a = this.anovaStats(categoryData);
        return a.F;
    }

    public double anovaPValue(Collection categoryData) throws IllegalArgumentException, MathException {
        AnovaStats a = this.anovaStats(categoryData);
        FDistributionImpl fdist = new FDistributionImpl(a.dfbg, a.dfwg);
        return 1.0 - fdist.cumulativeProbability(a.F);
    }

    public boolean anovaTest(Collection categoryData, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.anovaPValue(categoryData) < alpha;
    }

    private AnovaStats anovaStats(Collection categoryData) throws IllegalArgumentException, MathException {
        if (categoryData.size() < 2) {
            throw new IllegalArgumentException("ANOVA: two or more categories required");
        }
        Iterator iterator = categoryData.iterator();
        while (iterator.hasNext()) {
            double[] array;
            try {
                array = (double[])iterator.next();
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("ANOVA: categoryData contains non-double[] elements.");
            }
            if (array.length > 1) continue;
            throw new IllegalArgumentException("ANOVA: one element of categoryData has fewer than 2 values.");
        }
        int dfwg = 0;
        double sswg = 0.0;
        Sum totsum = new Sum();
        SumOfSquares totsumsq = new SumOfSquares();
        int totnum = 0;
        Iterator iterator2 = categoryData.iterator();
        while (iterator2.hasNext()) {
            double[] data = (double[])iterator2.next();
            Sum sum = new Sum();
            SumOfSquares sumsq = new SumOfSquares();
            int num = 0;
            for (int i = 0; i < data.length; ++i) {
                double val = data[i];
                ++num;
                sum.increment(val);
                sumsq.increment(val);
                ++totnum;
                totsum.increment(val);
                totsumsq.increment(val);
            }
            dfwg += num - 1;
            double ss = sumsq.getResult() - sum.getResult() * sum.getResult() / (double)num;
            sswg += ss;
        }
        double sst = totsumsq.getResult() - totsum.getResult() * totsum.getResult() / (double)totnum;
        double ssbg = sst - sswg;
        int dfbg = categoryData.size() - 1;
        double msbg = ssbg / (double)dfbg;
        double mswg = sswg / (double)dfwg;
        double F = msbg / mswg;
        return new AnovaStats(dfbg, dfwg, F);
    }

    private static class AnovaStats {
        private int dfbg;
        private int dfwg;
        private double F;

        AnovaStats(int dfbg, int dfwg, double F) {
            this.dfbg = dfbg;
            this.dfwg = dfwg;
            this.F = F;
        }
    }
}

