/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixImpl;

public class VectorialCovariance
implements Serializable {
    private static final long serialVersionUID = 4118372414238930270L;
    private double[] sums;
    private double[] productsSums;
    private boolean isBiasCorrected;
    private long n;

    public VectorialCovariance(int dimension, boolean isBiasCorrected) {
        this.sums = new double[dimension];
        this.productsSums = new double[dimension * (dimension + 1) / 2];
        this.n = 0L;
        this.isBiasCorrected = isBiasCorrected;
    }

    public void increment(double[] v) throws DimensionMismatchException {
        if (v.length != this.sums.length) {
            throw new DimensionMismatchException(v.length, this.sums.length);
        }
        int k = 0;
        for (int i = 0; i < v.length; ++i) {
            int n = i;
            this.sums[n] = this.sums[n] + v[i];
            for (int j = 0; j <= i; ++j) {
                int n2 = k++;
                this.productsSums[n2] = this.productsSums[n2] + v[i] * v[j];
            }
        }
        ++this.n;
    }

    public RealMatrix getResult() {
        int dimension = this.sums.length;
        RealMatrixImpl result = new RealMatrixImpl(dimension, dimension);
        if (this.n > 1L) {
            double[][] resultData = result.getDataRef();
            double c = 1.0 / (double)(this.n * (this.isBiasCorrected ? this.n - 1L : this.n));
            int k = 0;
            for (int i = 0; i < dimension; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double e;
                    resultData[i][j] = e = c * ((double)this.n * this.productsSums[k++] - this.sums[i] * this.sums[j]);
                    resultData[j][i] = e;
                }
            }
        }
        return result;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.n = 0L;
        Arrays.fill(this.sums, 0.0);
        Arrays.fill(this.productsSums, 0.0);
    }
}

