/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import java.util.HashMap;
import java.util.HashSet;
import jfm.model.Rotation;
import jfm.model.Types;
import jfm.xml.JFMObjectParser;
import jfm.xml.ObjectParser;
import jfm.xml.TextParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

final class RotationParser
extends JFMObjectParser {
    Types.CropType id;

    public RotationParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("id", JFMObjectParser.mandatoryAttribute);
    }

    public void initializeObject() throws XMLObjectException, XMLSyntaxException {
        this.id = Types.xmlToCropType(this.getNamedAttribute("id"));
        HashMap<Types.DiseaseType, double[]> rotpenaltymap = new HashMap<Types.DiseaseType, double[]>();
        HashSet<Types.DiseaseType> forbid = new HashSet<Types.DiseaseType>();
        if (this.parserListExists("csv")) {
            try {
                block6: for (int i = 0; i < this.getParserList("csv").size(); ++i) {
                    TextParser csvp = (TextParser)this.getParserList("csv").get(i);
                    String[] vals = csvp.getCSV();
                    switch (csvp.dataType) {
                        case ROTPENALTY: {
                            Types.DiseaseType dt = Types.xmlToDiseaseType(vals[0]);
                            double[] rotcosts = new double[]{Double.parseDouble(vals[1]) * 0.01, Double.parseDouble(vals[2])};
                            rotpenaltymap.put(dt, rotcosts);
                            continue block6;
                        }
                        case FORBIDDEN: {
                            for (String str : vals) {
                                forbid.add(Types.xmlToDiseaseType(str));
                            }
                            continue block6;
                        }
                        default: {
                            throw new XMLSyntaxException("only rotpenalty or forbidden csv type allowed for rotations");
                        }
                    }
                }
            }
            catch (NumberFormatException ex) {
                throw new XMLSyntaxException(ex.getMessage());
            }
        }
        this.obj = new Rotation(this.id, rotpenaltymap, forbid);
    }

    protected boolean isPrimitive() {
        return false;
    }

    public String name() {
        if (this.id != null) {
            return this.id.xmlname;
        }
        return "rotation";
    }

    public String parsesNode() {
        return "rotation";
    }

    public String toString() {
        return "RotationParser";
    }
}

