/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jfm.model.Types;
import jfm.xml.XMLSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Formula {
    private Node root;
    private String originalString;
    private boolean variablesChanged = true;
    private double cachedValue = 0.0;
    private final Set<Types.VariableType> requiredVariables = new HashSet<Types.VariableType>();
    private Set<Types.VariableType> unsetVariables = new HashSet<Types.VariableType>();
    private final Map<Types.VariableType, Double> variableValues = new HashMap<Types.VariableType, Double>();

    public Formula(String input) {
        this.parse(input);
    }

    public void parse(String input) {
        this.originalString = input;
        this.root = this.isBranchNode(input) ? new BranchNode() : new LeafNode();
        try {
            this.root.parse(input);
        }
        catch (Exception ex) {
            throw new Error("Error parsing formula" + ex.getMessage());
        }
        this.variablesChanged = true;
    }

    public Formula copy() {
        Formula newF = new Formula(this.originalString);
        return newF;
    }

    public String getFormula() {
        return this.originalString;
    }

    public Set<Types.VariableType> requiredVariables() {
        return Collections.unmodifiableSet(this.requiredVariables);
    }

    public void setVariable(Types.VariableType type, double val) {
        if (this.requiredVariables.contains((Object)type)) {
            if (this.variableValues.containsKey((Object)type)) {
                if (val != this.variableValues.get((Object)type)) {
                    this.variablesChanged = true;
                }
            } else {
                this.variablesChanged = true;
            }
            this.variableValues.put(type, val);
            this.unsetVariables.remove((Object)type);
        }
    }

    public double calculateValue() {
        if (this.variablesChanged) {
            if (this.unsetVariables.size() > 0) {
                throw new Error("There were unset variables in the formula " + this.originalString + "\n" + this.unsetVariables);
            }
            this.cachedValue = this.root.calculateValue();
            this.variablesChanged = false;
        }
        return this.cachedValue;
    }

    private String getBracedVariable(String fString, int ci) {
        int openBracketCount = 1;
        for (int i = ci; i < fString.length(); ++i) {
            char c = fString.charAt(i);
            if (c == '{') {
                ++openBracketCount;
            }
            if (c == '}') {
                --openBracketCount;
            }
            if (openBracketCount != 0) continue;
            return fString.substring(ci - 1, i + 1);
        }
        throw new Error("Reached End of String but no closing brace found");
    }

    private String getBracket(String fString, int ci) {
        int openBracketCount = 1;
        for (int i = ci; i < fString.length(); ++i) {
            char c = fString.charAt(i);
            if (c == '(') {
                ++openBracketCount;
            }
            if (c == ')') {
                --openBracketCount;
            }
            if (openBracketCount != 0) continue;
            return fString.substring(ci - 1, i + 1);
        }
        throw new Error("Reached End of String but no closing bracket found " + fString);
    }

    private String getNumber(String fString, int ci) {
        for (int i = ci; i < fString.length(); ++i) {
            char c = fString.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return fString.substring(ci, i);
        }
        return fString.substring(ci);
    }

    private boolean isBranchNode(String str) {
        return str.contains("*") || str.contains("-") || str.contains("+") || str.contains("/") || str.contains("^");
    }

    private String stripBraces(String str) {
        char c = str.charAt(0);
        if (c != '{') {
            return str;
        }
        return str.substring(1, str.length() - 1);
    }

    private String stripUnwantedBrackets(String str) {
        char c = str.charAt(0);
        if (c != '(') {
            return str;
        }
        int openBracketCount = 1;
        for (int i = 1; i < str.length() - 1; ++i) {
            c = str.charAt(i);
            if (c == '(') {
                ++openBracketCount;
            }
            if (c == ')') {
                --openBracketCount;
            }
            if (openBracketCount != 0) continue;
            return str;
        }
        if (openBracketCount == 1 && str.charAt(str.length() - 1) == ')') {
            return str.substring(1, str.length() - 1);
        }
        throw new Error("Unclosed bracket when attempting to strip excess ");
    }

    private class BranchNode
    extends Node {
        FOperator op;
        Node LHS;
        Node RHS;

        private BranchNode() {
        }

        double calculateValue() {
            double lhv = this.LHS.calculateValue();
            double rhv = this.RHS.calculateValue();
            return this.op.operate(lhv, rhv);
        }

        public void parse(String fString) throws XMLSyntaxException {
            int i;
            this.originalString = fString = Formula.this.stripUnwantedBrackets(fString);
            ArrayList<String> operands = new ArrayList<String>();
            ArrayList<FOperator> operators = new ArrayList<FOperator>();
            block11: for (int ci = 0; ci < fString.length(); ++ci) {
                char c = fString.charAt(ci);
                if (Character.isDigit(c) || c == '.') {
                    String number = Formula.this.getNumber(fString, ci);
                    operands.add(number);
                    if ((ci += number.length()) >= fString.length()) break;
                    c = fString.charAt(ci);
                }
                switch (c) {
                    case '(': {
                        String brac = Formula.this.getBracket(fString, ci + 1);
                        operands.add(brac);
                        ci += brac.length() - 1;
                        continue block11;
                    }
                    case ')': {
                        throw new Error("Unopened close bracket encountered in formula " + fString);
                    }
                    case '{': {
                        String brace = Formula.this.getBracedVariable(fString, ci + 1);
                        operands.add(brace);
                        ci += brace.length() - 1;
                        continue block11;
                    }
                    case '}': {
                        throw new Error("Unopened close brace encountered in formula");
                    }
                    case '^': {
                        operators.add(FOperator.POWER);
                        continue block11;
                    }
                    case '*': {
                        operators.add(FOperator.TIMES);
                        continue block11;
                    }
                    case '/': {
                        operators.add(FOperator.DIVIDE);
                        continue block11;
                    }
                    case '-': {
                        operators.add(FOperator.MINUS);
                        continue block11;
                    }
                    case '+': {
                        operators.add(FOperator.PLUS);
                        continue block11;
                    }
                    default: {
                        if (Character.isDigit(c) || c == '.') {
                            String number = Formula.this.getNumber(fString, ci);
                            operands.add(number);
                            ci += number.length();
                            continue block11;
                        }
                        throw new Error("Unrecognised character " + c + " in formula " + fString);
                    }
                }
            }
            if (operators.size() + 1 != operands.size()) {
                StringBuffer buff = new StringBuffer();
                buff.append("Operator ");
                for (FOperator op : operators) {
                    buff.append((Object)((Object)op) + " ");
                }
                buff.append("\n");
                for (String s : operands) {
                    buff.append(s + "|");
                }
                throw new Error("There must be exactly one fewer operators than operands \n" + buff.toString());
            }
            if (operators.size() == 0) {
                throw new Error("Branch Node must have at least one operator");
            }
            int separatingOp = operators.indexOf((Object)FOperator.PLUS);
            if (separatingOp == -1) {
                separatingOp = operators.indexOf((Object)FOperator.MINUS);
            }
            if (separatingOp == -1) {
                separatingOp = operators.indexOf((Object)FOperator.TIMES);
            }
            if (separatingOp == -1) {
                separatingOp = operators.indexOf((Object)FOperator.DIVIDE);
            }
            if (separatingOp == -1) {
                separatingOp = operators.indexOf((Object)FOperator.POWER);
            }
            if (separatingOp == -1) {
                throw new Error("No separating operation");
            }
            StringBuffer lstrbuff = new StringBuffer();
            StringBuffer rstrbuff = new StringBuffer();
            lstrbuff.append((String)operands.get(0));
            for (i = 1; i <= separatingOp; ++i) {
                lstrbuff.append(((FOperator)((Object)operators.get((int)(i - 1)))).token);
                lstrbuff.append((String)operands.get(i));
            }
            rstrbuff.append((String)operands.get(separatingOp + 1));
            for (i = separatingOp + 2; i < operands.size(); ++i) {
                if (operators.get(separatingOp) == FOperator.MINUS) {
                    if (operators.get(i - 1) == FOperator.MINUS) {
                        rstrbuff.append(FOperator.PLUS.token);
                    } else if (operators.get(i - 1) == FOperator.PLUS) {
                        rstrbuff.append(FOperator.MINUS.token);
                    } else {
                        rstrbuff.append(((FOperator)((Object)operators.get((int)(i - 1)))).token);
                    }
                } else {
                    rstrbuff.append(((FOperator)((Object)operators.get((int)(i - 1)))).token);
                }
                rstrbuff.append((String)operands.get(i));
            }
            this.LHS = this.assignNode(lstrbuff.toString());
            this.RHS = this.assignNode(rstrbuff.toString());
            this.op = (FOperator)((Object)operators.get(separatingOp));
        }
    }

    private class LeafNode
    extends Node {
        private double value;
        private Types.VariableType var;

        private LeafNode() {
            this.value = 0.0;
            this.var = null;
        }

        public void parse(String fString) throws XMLSyntaxException {
            this.originalString = fString = Formula.this.stripUnwantedBrackets(fString);
            if (Types.variableTypeExists(fString = Formula.this.stripBraces(fString))) {
                this.var = Types.xmlToVariableType(fString);
                Formula.this.requiredVariables.add(this.var);
                Formula.this.unsetVariables.add(this.var);
            } else {
                this.value = Double.parseDouble(fString);
            }
        }

        double calculateValue() {
            if (this.var == null) {
                return this.value;
            }
            if (Formula.this.variableValues.containsKey((Object)this.var)) {
                return (Double)Formula.this.variableValues.get((Object)this.var);
            }
            throw new Error("No value specified for " + (Object)((Object)this.var));
        }
    }

    private abstract class Node {
        protected String originalString = "";

        private Node() {
        }

        public String originalString() {
            return this.originalString;
        }

        abstract void parse(String var1) throws XMLSyntaxException;

        abstract double calculateValue();

        protected Node assignNode(String str) throws XMLSyntaxException {
            Node theNode = Formula.this.isBranchNode(str) ? new BranchNode() : new LeafNode();
            theNode.parse(str);
            return theNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FOperator {
        TIMES('*'),
        MINUS('-'),
        PLUS('+'),
        DIVIDE('/'),
        POWER('^');

        char token;

        private FOperator(char t) {
            this.token = t;
        }

        public static FOperator charToOp(char c) {
            switch (c) {
                case '*': {
                    return TIMES;
                }
                case '/': {
                    return DIVIDE;
                }
                case '-': {
                    return MINUS;
                }
                case '+': {
                    return PLUS;
                }
                case '^': {
                    return POWER;
                }
            }
            throw new Error("The operator " + c + "is not recognised");
        }

        public double operate(double lhs, double rhs) {
            switch (this.token) {
                case '*': {
                    return lhs * rhs;
                }
                case '/': {
                    return lhs / rhs;
                }
                case '-': {
                    return lhs - rhs;
                }
                case '+': {
                    return lhs + rhs;
                }
                case '^': {
                    return Math.pow(lhs, rhs);
                }
            }
            throw new Error("token for " + (Object)((Object)this) + " is not a mathematical operator");
        }
    }
}

