/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.Crop;
import jfm.model.CropYear;
import jfm.model.Disease;
import jfm.model.Farm;
import jfm.model.Limit;
import jfm.model.Location;
import jfm.model.Operation;
import jfm.model.Rotation;
import jfm.model.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CroppingComponent
extends ModelComponent {
    private final Map<Types.DiseaseType, Disease> diseases = new HashMap<Types.DiseaseType, Disease>();
    private final List<Limit> limits = new ArrayList<Limit>();
    private final Map<Types.CropType, Crop> crops = new HashMap<Types.CropType, Crop>();
    private final Set<CropYear> cropYearsSet = new LinkedHashSet<CropYear>();
    private static String constraintTag = "Cropping";

    public Disease getDisease(Types.DiseaseType type) {
        if (this.diseases.containsKey((Object)type)) {
            return this.diseases.get((Object)type);
        }
        throw new Error("Attempt to get undefined disease of type " + (Object)((Object)type));
    }

    public boolean replaceDisease(Types.DiseaseType type, Disease newDisease) {
        if (this.diseases.containsKey((Object)type)) {
            this.diseases.put(type, newDisease);
            return true;
        }
        return false;
    }

    public Crop getCrop(Types.CropType baseType) {
        if (!this.crops.containsKey((Object)baseType)) {
            throw new Error("Request for undefined crop type " + (Object)((Object)baseType));
        }
        return this.crops.get((Object)baseType);
    }

    @Override
    public void setFormulaVariables() {
        for (Crop cp : this.crops.values()) {
            cp.setFormulaVariables(this.getParent().location());
        }
    }

    public Map<Types.CropType, Crop> copyCrops() {
        LinkedHashMap<Types.CropType, Crop> cps = new LinkedHashMap<Types.CropType, Crop>();
        for (Crop cp : this.crops.values()) {
            Crop cpcpy = cp.copy();
            cpcpy.deRegisterCopies();
            cps.put(cp.type, cpcpy);
        }
        return cps;
    }

    public Map<Types.CropType, Crop> getCrops() {
        Map<Types.CropType, Crop> cps = Collections.unmodifiableMap(this.crops);
        return cps;
    }

    public Set<Types.CropType> baseCropTypes() {
        return Collections.unmodifiableSet(this.crops.keySet());
    }

    public Set<CropYear> cropYears() {
        return Collections.unmodifiableSet(this.cropYearsSet);
    }

    public void clearCrops() {
        this.crops.clear();
        this.cropYearsSet.clear();
        this.requireMatrixRebuild();
    }

    public void clearLimits() {
        this.limits.clear();
        this.requireMatrixRebuild();
    }

    public void addLimit(Limit lim) {
        this.limits.add(lim);
        this.requireMatrixRebuild();
    }

    public CroppingComponent() {
        super(ModelComponent.MCType.CROPPING);
        this.requireObjective(Types.ObjectiveType.PROFIT);
        this.addConstraintBuilder(new OperationAreaConstraint());
        this.addConstraintBuilder(new OperationSequencingConstraint());
        this.addConstraintBuilder(new NonSequentialOperationConstraint());
        this.addConstraintBuilder(new DiseaseConstraint());
        this.addConstraintBuilder(new OperationMinAreaConstraint());
        this.addConstraintBuilder(new AreaLimitConstraint());
    }

    public void addCrop(Crop newCrop) {
        Types.CropType type = newCrop.type;
        if (this.crops.containsKey((Object)type)) {
            throw new Error("Can't add crop of type " + (Object)((Object)type) + " because there is already a crop with that type");
        }
        for (int i = 0; i < newCrop.getYearCopies().size(); ++i) {
            this.cropYearsSet.add(new CropYear(type, i));
        }
        this.crops.put(type, newCrop);
        this.requireMatrixRebuild();
    }

    public void addDisease(Disease newDisease) {
        Types.DiseaseType baseType = newDisease.base;
        if (this.diseases.containsKey((Object)baseType)) {
            throw new Error("Can't add disease of type " + (Object)((Object)baseType) + " because a disease with that type already exists ");
        }
        this.diseases.put(baseType, newDisease);
        this.requireMatrixRebuild();
    }

    @Override
    public CroppingComponent copy() {
        CroppingComponent cpcpy = new CroppingComponent();
        for (Crop cb : this.crops.values()) {
            cpcpy.addCrop(cb.copy());
        }
        for (Disease dp : this.diseases.values()) {
            cpcpy.addDisease(dp);
        }
        for (Limit lm : this.limits) {
            cpcpy.addLimit(lm.copy());
        }
        return cpcpy;
    }

    List<Crop.CropCopy> cropsUsed() {
        ArrayList<Crop.CropCopy> thelist = new ArrayList<Crop.CropCopy>();
        for (CropYear cy : this.cropYearsSet) {
            Crop.CropCopy cp = this.crops.get((Object)cy.base).getCopy(cy.copyYear);
            if (!(cp.getSolvedArea() > 0.0)) continue;
            thelist.add(cp);
        }
        return thelist;
    }

    double[] getRotationPenalty(Types.CropType to, Types.DiseaseType from) {
        if (this.crops.containsKey((Object)to)) {
            Rotation torot = this.crops.get((Object)to).rotation();
            return torot.getPenalty(from);
        }
        double[] nocosts = new double[]{0.0, 0.0};
        return nocosts;
    }

    Set<Types.CropType> cropsWithDisease(Types.DiseaseType dis) {
        HashSet<Types.CropType> cps = new HashSet<Types.CropType>();
        if (dis == Types.DiseaseType.NONE) {
            return cps;
        }
        for (Types.CropType ctype : this.crops.keySet()) {
            if (this.crops.get((Object)((Object)ctype)).diseaseType != dis) continue;
            cps.add(ctype);
        }
        return cps;
    }

    public boolean diseasesAndRotationsComplete() {
        for (Crop cp : this.crops.values()) {
            if (this.diseases.containsKey((Object)cp.diseaseType) || cp.diseaseType == Types.DiseaseType.NONE) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void initializeStructure() {
        Location location = this.getParent().location();
        for (Types.CropType ct : this.crops.keySet()) {
            List<Crop.CropCopy> clist = this.crops.get((Object)ct).getYearCopies();
            for (int i = 0; i < clist.size(); ++i) {
                Crop.CropCopy cp = clist.get(i);
                cp.registerParent(this);
                MatrixVariable newVariable = new MatrixVariable(cp.grossMargin(), 0.0, 1.0, LPX.LPX_LO, LPX.LPX_CV, this.matrix.numCols(), Types.ObjectiveType.PROFIT);
                newVariable.setTag(ct.xmlname + "_" + cp.copyYear());
                this.matrix.addVariable(newVariable);
                cp.registerVariable(newVariable, 0);
                for (Operation op : cp.operations()) {
                    op.registerParent(this);
                    ArrayList<Integer> pallow = new ArrayList<Integer>(op.unfoldedAllowedSet());
                    Collections.sort(pallow);
                    for (Integer p : pallow) {
                        newVariable = new MatrixVariable(-op.cost(p, cp, location, this.getParent().fuelPrice()), 0.0, 0.0, LPX.LPX_LO, LPX.LPX_CV, this.matrix.numCols(), Types.ObjectiveType.PROFIT);
                        this.matrix.addVariable(newVariable);
                        newVariable.setTag(ct.xmlname + "_" + cp.copyYear() + "_" + op.type.shortName + "_" + p);
                        op.registerVariable(newVariable, p);
                    }
                }
            }
        }
    }

    @Override
    protected void updateStructure() {
        for (Crop cp : this.crops.values()) {
            for (Crop.CropCopy cy : cp.getYearCopies()) {
                cy.updateStructure(this);
            }
        }
        this.structureUpdateDone();
    }

    private final void buildLimitAreaConstraint(Limit lim) {
        int row = this.matrix.numRows();
        MatrixRow rowpointer = new MatrixRow(lim.min, lim.max, lim.type, row, constraintTag, "AreaLimit");
        this.matrix.addRow(rowpointer);
        ++row;
        HashSet<Types.CropType> limCrops = new HashSet<Types.CropType>(lim.getCropSubjects());
        Set<Types.CropType> allCrops = this.crops.keySet();
        limCrops.retainAll(allCrops);
        if (limCrops.size() != lim.getCropSubjects().size()) {
            throw new Error("One or more limit crops in the list \n" + lim.getCropSubjects() + "\n were not specified in the cropping model \n" + allCrops);
        }
        for (Types.CropType ct : limCrops) {
            List<Crop.CropCopy> cplist = this.crops.get((Object)ct).getYearCopies();
            for (Crop.CropCopy cp : cplist) {
                rowpointer.addElement(new MatrixElement(cp.getDependentColumn(0), 1.0));
            }
        }
    }

    @Override
    public String name() {
        return "cropping";
    }

    public String toString() {
        StringBuffer outstring = new StringBuffer();
        outstring.append("--- Cropping --- \n");
        outstring.append("Total Area ");
        outstring.append("\n");
        for (Crop cp : this.crops.values()) {
            outstring.append(cp);
        }
        outstring.append("Diseases \n");
        for (Disease ds : this.diseases.values()) {
            outstring.append(ds);
        }
        outstring.append("Limits \n");
        for (Limit lt : this.limits) {
            outstring.append(lt);
        }
        return outstring.toString();
    }

    public String printSolution(Farm model, boolean detailed) {
        Crop.CropCopy cp;
        StringBuffer outstring = new StringBuffer();
        DecimalFormat f1 = new DecimalFormat("#0.00");
        outstring.append("--- Cropping --- \n");
        outstring.append("Total Area ");
        outstring.append("\n");
        for (CropYear cy : this.cropYearsSet) {
            cp = this.crops.get((Object)cy.base).getCopy(cy.copyYear);
            if (!(cp.solvedArea() > 0.0)) continue;
            outstring.append(cp.name() + ": " + f1.format(cp.solvedArea()) + "\n");
        }
        if (detailed) {
            outstring.append("\n");
            for (CropYear cy : this.cropYearsSet) {
                cp = this.crops.get((Object)cy.base).getCopy(cy.copyYear);
                if (!(cp.solvedArea() > 0.0)) continue;
                outstring.append(cp.printSolution(' '));
            }
        }
        return outstring.toString();
    }

    public String printCSVWorkPlan() {
        StringBuffer outstring = new StringBuffer();
        for (CropYear cy : this.cropYearsSet) {
            Crop.CropCopy cp = this.crops.get((Object)cy.base).getCopy(cy.copyYear);
            outstring.append(cp.name() + "\n");
            if (!(cp.solvedArea() > 0.0)) continue;
            outstring.append(cp.printSolution(','));
        }
        return outstring.toString();
    }

    public final class AreaLimitConstraint
    extends ConstraintBuilder {
        public AreaLimitConstraint() {
            super(ConstraintBuilder.CBType.AREALIMIT, ModelComponent.MCType.CROPPING);
        }

        protected void build() {
            block3: for (Limit lim : CroppingComponent.this.limits) {
                switch (lim.limitType) {
                    case AREA: {
                        CroppingComponent.this.buildLimitAreaConstraint(lim);
                        continue block3;
                    }
                }
                throw new Error("No constraint defined for limit type" + (Object)((Object)lim.limitType));
            }
        }
    }

    public final class DiseaseConstraint
    extends ConstraintBuilder {
        public DiseaseConstraint() {
            super(ConstraintBuilder.CBType.DISEASE, ModelComponent.MCType.CROPPING);
        }

        protected void build() {
            int row = CroppingComponent.this.matrix.numRows();
            for (Types.DiseaseType dt : CroppingComponent.this.diseases.keySet()) {
                Disease dis = (Disease)CroppingComponent.this.diseases.get((Object)dt);
                Disease assocdis = (Disease)CroppingComponent.this.diseases.get((Object)dis.associated);
                MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, constraintTag, "disease_" + (Object)((Object)dt));
                CroppingComponent.this.matrix.addRow(rowpointer);
                ++row;
                Set<Types.CropType> withdisease = CroppingComponent.this.cropsWithDisease(dt);
                Set<Types.CropType> withassociated = CroppingComponent.this.cropsWithDisease(dis.associated);
                for (Types.CropType croptype : CroppingComponent.this.crops.keySet()) {
                    Crop.CropCopy cp = ((Crop)CroppingComponent.this.crops.get((Object)croptype)).getCopy(0);
                    if (!withdisease.contains((Object)croptype) && !withassociated.contains((Object)croptype)) {
                        rowpointer.addElement(new MatrixElement(cp.getDependentColumn(0), 1.0));
                        continue;
                    }
                    if (withdisease.contains((Object)croptype) && !withassociated.contains((Object)croptype)) {
                        rowpointer.addElement(new MatrixElement(cp.getDependentColumn(0), -dis.minBreak));
                        continue;
                    }
                    if (withassociated.contains((Object)croptype) && !withdisease.contains((Object)croptype)) {
                        rowpointer.addElement(new MatrixElement(cp.getDependentColumn(0), -assocdis.minBreak));
                        continue;
                    }
                    rowpointer.addElement(new MatrixElement(cp.getDependentColumn(0), -Math.min(assocdis.minBreak, dis.minBreak)));
                }
            }
        }
    }

    public final class OperationMinAreaConstraint
    extends ConstraintBuilder {
        public OperationMinAreaConstraint() {
            super(ConstraintBuilder.CBType.OPMINAREA, ModelComponent.MCType.CROPPING);
        }

        protected void build() {
            int row = CroppingComponent.this.matrix.numRows();
            for (Types.CropType ct : CroppingComponent.this.crops.keySet()) {
                List<Crop.CropCopy> clist = ((Crop)CroppingComponent.this.crops.get((Object)ct)).getYearCopies();
                for (int i = 0; i < clist.size(); ++i) {
                    Crop.CropCopy cp = clist.get(i);
                    List<Operation> cpOps = cp.operations();
                    int nops = cpOps.size();
                    for (int o = 0; o < nops; ++o) {
                        Operation op = cpOps.get(o);
                        if (!op.hasMinAreas()) continue;
                        Set<Integer> pallow = op.unfoldedAllowedSet();
                        for (Integer p : pallow) {
                            if (!(op.minArea(p) > 0.0)) continue;
                            MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, constraintTag, this.type().tag + "_" + (Object)((Object)ct) + "_" + (Object)((Object)op.type) + "_p" + p);
                            CroppingComponent.this.matrix.addRow(rowpointer);
                            ++row;
                            rowpointer.addElement(new MatrixElement(op.getDependentColumn(p), 1.0));
                            rowpointer.addElement(new MatrixElement(cp.getDependentColumn(0), -op.minArea(p)));
                        }
                    }
                }
            }
        }
    }

    public final class OperationSequencingConstraint
    extends ConstraintBuilder {
        public OperationSequencingConstraint() {
            super(ConstraintBuilder.CBType.OPSEQ, ModelComponent.MCType.CROPPING);
        }

        protected void build() {
            int row = CroppingComponent.this.matrix.numRows();
            for (Types.CropType ct : CroppingComponent.this.crops.keySet()) {
                List<Crop.CropCopy> clist = ((Crop)CroppingComponent.this.crops.get((Object)ct)).getYearCopies();
                for (int i = 0; i < clist.size(); ++i) {
                    Crop.CropCopy cp = clist.get(i);
                    List<Operation> cpOps = cp.operations();
                    int nops = cpOps.size();
                    for (int o = 1; o < nops; ++o) {
                        Operation op = cpOps.get(o);
                        if (!op.isSequential()) continue;
                        Operation prevop = cpOps.get(o - 1);
                        Set<Integer> opallow = op.unfoldedAllowedSet();
                        Set<Integer> prevopallow = prevop.unfoldedAllowedSet();
                        HashSet<Integer> peitherallow = new HashSet<Integer>(opallow);
                        HashSet<Integer> pbothallow = new HashSet<Integer>(opallow);
                        peitherallow.addAll(prevopallow);
                        pbothallow.retainAll(prevopallow);
                        HashSet<Integer> pbothallowPlusGap = new HashSet<Integer>(pbothallow);
                        int popmin = Collections.min(opallow);
                        for (int g = 1; g <= prevop.gap; ++g) {
                            int pgap = popmin - g;
                            if (!prevopallow.contains(pgap)) continue;
                            pbothallowPlusGap.add(pgap);
                        }
                        if (Collections.min(prevopallow) + prevop.gap > Collections.max(opallow)) {
                            throw new Error("The sequence of operations " + (Object)((Object)prevop.type) + " followed by " + (Object)((Object)op.type) + " in crop " + cp.name() + " has a sequencing infeasibility \n ---> check dates and mingap requirements \n");
                        }
                        if (pbothallowPlusGap.size() <= 0) continue;
                        for (Integer pboth : pbothallowPlusGap) {
                            MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, constraintTag, this.type().tag + "_" + (Object)((Object)ct) + "_" + (Object)((Object)op.type) + "_p" + pboth);
                            CroppingComponent.this.matrix.addRow(rowpointer);
                            ++row;
                            for (int p = Collections.min(peitherallow).intValue(); p <= pboth; ++p) {
                                if (opallow.contains(p)) {
                                    rowpointer.addElement(new MatrixElement(op.getDependentColumn(p), -1.0));
                                }
                                if (!prevopallow.contains(p) || p + prevop.gap > pboth) continue;
                                rowpointer.addElement(new MatrixElement(prevop.getDependentColumn(p), 1.0));
                            }
                        }
                    }
                }
            }
        }
    }

    public final class NonSequentialOperationConstraint
    extends ConstraintBuilder {
        public NonSequentialOperationConstraint() {
            super(ConstraintBuilder.CBType.NONSEQOP, ModelComponent.MCType.CROPPING);
        }

        protected void build() {
            int row = CroppingComponent.this.matrix.numRows();
            for (Types.CropType ct : CroppingComponent.this.crops.keySet()) {
                for (Crop.CropCopy cp : ((Crop)CroppingComponent.this.crops.get((Object)ct)).getYearCopies()) {
                    List<Operation> cropOps = cp.operations();
                    int nops = cropOps.size();
                    for (int o = 1; o < nops; ++o) {
                        Operation op = cropOps.get(o);
                        MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_FX, row, constraintTag, this.type().tag + "_" + (Object)((Object)ct) + "_" + (Object)((Object)op.type));
                        CroppingComponent.this.matrix.addRow(rowpointer);
                        rowpointer.addElement(new MatrixElement(cp.getDependentColumn(0), -1.0));
                        ++row;
                        for (Integer p : op.unfoldedAllowedSet()) {
                            rowpointer.addElement(new MatrixElement(op.getDependentColumn(p), 1.0));
                        }
                    }
                }
            }
        }
    }

    public final class OperationAreaConstraint
    extends ConstraintBuilder {
        public OperationAreaConstraint() {
            super(ConstraintBuilder.CBType.OPAREA, ModelComponent.MCType.CROPPING);
        }

        protected void build() {
            int row = CroppingComponent.this.matrix.numRows();
            for (Types.CropType ct : CroppingComponent.this.crops.keySet()) {
                for (Crop.CropCopy cp : ((Crop)CroppingComponent.this.crops.get((Object)ct)).getYearCopies()) {
                    MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_FX, row, constraintTag, this.type().tag + "_" + (Object)((Object)ct));
                    CroppingComponent.this.matrix.addRow(rowpointer);
                    ++row;
                    rowpointer.addElement(new MatrixElement(cp.getDependentColumn(0), -1.0));
                    Operation op = cp.operations().get(0);
                    for (Integer p : op.unfoldedAllowedSet()) {
                        rowpointer.addElement(new MatrixElement(op.getDependentColumn(p), 1.0));
                    }
                }
            }
        }
    }
}

