/*
 * Decompiled with CFR 0.152.
 */
package jfm.lp;

import java.util.HashMap;
import java.util.Map;
import jfm.lp.CBCPeer;
import jfm.lp.GLPKPeer;
import jfm.lp.LPX;
import jfm.lp.Matrix;
import jfm.xml.XMLSyntaxException;

public abstract class LPPeer {
    public final Solver type;
    private static Map<String, Solver> xmlToSolverType = new HashMap<String, Solver>();

    protected LPPeer(Solver type_) {
        this.type = type_;
    }

    public static LPPeer create(Matrix matrix_, Solver slvr) {
        switch (slvr) {
            case GLPK: {
                return new GLPKPeer(matrix_);
            }
            case CLP: {
                return new CBCPeer(matrix_);
            }
        }
        throw new Error("Unreckognised Solver type" + (Object)((Object)slvr));
    }

    public static Solver xmlToSolverType(String str) throws XMLSyntaxException {
        if (xmlToSolverType.containsKey(str)) {
            return xmlToSolverType.get(str);
        }
        throw new XMLSyntaxException("The string " + str + " does not correspond to a solver type");
    }

    public abstract void setTermOut(LPX var1);

    protected abstract LPX solve();

    static {
        for (Solver v : Solver.values()) {
            xmlToSolverType.put(v.xmlName, v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Solver {
        GLPK("glpk"),
        CLP("cbc");

        public final String xmlName;

        private Solver(String xmln) {
            this.xmlName = xmln;
        }
    }
}

