/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math.ode.AbstractStepInterpolator;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;

abstract class RungeKuttaStepInterpolator
extends AbstractStepInterpolator {
    protected double[][] yDotK;
    protected FirstOrderDifferentialEquations equations;

    protected RungeKuttaStepInterpolator() {
        this.yDotK = null;
        this.equations = null;
    }

    public RungeKuttaStepInterpolator(RungeKuttaStepInterpolator interpolator) {
        super(interpolator);
        if (interpolator.currentState != null) {
            int dimension = this.currentState.length;
            this.yDotK = new double[interpolator.yDotK.length][];
            for (int k = 0; k < interpolator.yDotK.length; ++k) {
                this.yDotK[k] = new double[dimension];
                System.arraycopy(interpolator.yDotK[k], 0, this.yDotK[k], 0, dimension);
            }
        } else {
            this.yDotK = null;
        }
        this.equations = null;
    }

    public void reinitialize(FirstOrderDifferentialEquations equations, double[] y, double[][] yDotK, boolean forward) {
        this.reinitialize(y, forward);
        this.yDotK = yDotK;
        this.equations = equations;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeBaseExternal(out);
        out.writeInt(this.yDotK.length);
        for (int k = 0; k < this.yDotK.length; ++k) {
            for (int i = 0; i < this.currentState.length; ++i) {
                out.writeDouble(this.yDotK[k][i]);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        double t = this.readBaseExternal(in);
        int kMax = in.readInt();
        this.yDotK = new double[kMax][];
        for (int k = 0; k < kMax; ++k) {
            this.yDotK[k] = new double[this.currentState.length];
            for (int i = 0; i < this.currentState.length; ++i) {
                this.yDotK[k][i] = in.readDouble();
            }
        }
        this.equations = null;
        try {
            this.setInterpolatedTime(t);
        }
        catch (DerivativeException e) {
            throw new IOException(e.getMessage());
        }
    }
}

