/*
 * Decompiled with CFR 0.152.
 */
package jfm.r;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DocumentEditor {
    public static int findAttribute(Node node, String attName) {
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.item(i).getNodeName();
            if (!name.equals(attName)) continue;
            return i;
        }
        return -1;
    }

    public static String printNode(Node node, String indent) {
        StringBuffer buff = new StringBuffer();
        switch (node.getNodeType()) {
            case 9: {
                buff.append("<xml version=\"1.0\">\n\n");
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    buff.append(DocumentEditor.printNode(nodes.item(i), indent + "  "));
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                buff.append(indent + "<" + name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    buff.append(" " + current.getNodeName() + "=\"" + current.getNodeValue() + "\"");
                }
                buff.append(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    for (int i = 0; i < children.getLength(); ++i) {
                        buff.append(DocumentEditor.printNode(children.item(i), indent + "  "));
                    }
                }
                buff.append("</" + name + ">");
                break;
            }
            case 3: {
                buff.append(node.getNodeValue());
            }
        }
        return buff.toString();
    }
}

