/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jfm.lp.LPX;
import jfm.model.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Limit {
    public final LPX type;
    public final double min;
    public final double max;
    public final Types.LimitType limitType;
    private List<Object> subjectIdentifiers;

    public static Limit CropAreaLimit(Types.CropType cptype, LPX glpktype, double min_, double max_) {
        ArrayList<Object> subjects = new ArrayList<Object>();
        subjects.add((Object)cptype);
        return new Limit(subjects, Types.LimitType.AREA, glpktype, min_, max_);
    }

    public static Limit CropAreaLimit(Set<Types.CropType> cptypes, LPX glpktype, double min_, double max_) {
        ArrayList<Object> subjects = new ArrayList<Object>();
        for (Types.CropType cptype : cptypes) {
            subjects.add((Object)cptype);
        }
        return new Limit(subjects, Types.LimitType.AREA, glpktype, min_, max_);
    }

    public Limit(List<Object> subjects_, Types.LimitType lt, LPX type_, double min_, double max_) {
        this.subjectIdentifiers = Collections.unmodifiableList(subjects_);
        this.type = type_;
        this.min = min_;
        this.max = max_;
        this.limitType = lt;
    }

    List<Types.CropType> getCropSubjects() {
        ArrayList<Types.CropType> retlist = new ArrayList<Types.CropType>();
        for (Object obj : this.subjectIdentifiers) {
            if (obj instanceof Types.CropType) {
                retlist.add((Types.CropType)((Object)obj));
                continue;
            }
            throw new Error("Limit subjects should be of a uniform object type");
        }
        return retlist;
    }

    public Limit copy() {
        return new Limit(this.subjectIdentifiers, this.limitType, this.type, this.min, this.max);
    }
}

