% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VimpTable.R
\name{aggregate_vimp_table}
\alias{aggregate_vimp_table}
\alias{aggregate_vimp_table,list-method}
\alias{aggregate_vimp_table,character-method}
\alias{aggregate_vimp_table,vimpTable-method}
\alias{aggregate_vimp_table,NULL-method}
\alias{aggregate_vimp_table,experimentData-method}
\title{Aggregate variable importance from multiple variable importance
objects.}
\usage{
aggregate_vimp_table(x, aggregation_method, rank_threshold = NULL, ...)

\S4method{aggregate_vimp_table}{list}(x, aggregation_method, rank_threshold = NULL, ...)

\S4method{aggregate_vimp_table}{character}(x, aggregation_method, rank_threshold = NULL, ...)

\S4method{aggregate_vimp_table}{vimpTable}(x, aggregation_method, rank_threshold = NULL, ...)

\S4method{aggregate_vimp_table}{`NULL`}(x, aggregation_method, rank_threshold = NULL, ...)

\S4method{aggregate_vimp_table}{experimentData}(x, aggregation_method, rank_threshold = NULL, ...)
}
\arguments{
\item{x}{Variable importance (\code{vimpTable}) object, a list thereof, or one or
more paths to these objects.}

\item{aggregation_method}{Method used to aggregate variable importance. The
available methods are described in the \emph{feature selection methods} vignette.}

\item{rank_threshold}{Rank threshold used within several aggregation methods.
See the \emph{feature selection methods} vignette for more details.}

\item{...}{unused parameters.}
}
\value{
A \code{vimpTable} object with aggregated variable importance data.
}
\description{
This methods aggregates variable importance from one or more
\code{vimpTable} objects.
}
