% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcc_parity.R
\name{mcc_parity}
\alias{mcc_parity}
\title{Matthews Correlation Coefficient parity}
\usage{
mcc_parity(
  data,
  outcome,
  group,
  probs = NULL,
  preds = NULL,
  preds_levels = NULL,
  outcome_base = NULL,
  cutoff = 0.5,
  base = NULL,
  group_breaks = NULL
)
}
\arguments{
\item{data}{The dataframe that contains the necessary columns.}

\item{outcome}{The column name of the actual outcomes.}

\item{group}{Sensitive group to examine.}

\item{probs}{The column name or vector of the predicted probabilities (numeric between 0 - 1). If not defined, argument preds needs to be defined.}

\item{preds}{The column name or vector of the predicted binary outcome (0 or 1). If not defined, argument probs needs to be defined.}

\item{preds_levels}{The desired levels of the predicted binary outcome. If not defined, levels of the outcome variable are used.}

\item{outcome_base}{Base level for the target variable used to compute fairness metrics. Default is the first level of the outcome variable.}

\item{cutoff}{Cutoff to generate predicted outcomes from predicted probabilities. Default set to 0.5.}

\item{base}{Base level for sensitive group comparison.}

\item{group_breaks}{If group is continuous (e.g., age): either a numeric vector of two or more unique cut points or a single number >= 2 giving the number of intervals into which group feature is to be cut.}
}
\value{
\item{Metric}{Raw Matthews Correlation Coefficient metrics for all groups and metrics standardized for the base group (parity metric). Lower values compared to the reference group mean Matthews Correlation Coefficients in the selected subgroups}
\item{Metric_plot}{Bar plot of Matthews Correlation Coefficient metric}
\item{Probability_plot}{Density plot of predicted probabilities per subgroup. Only plotted if probabilities are defined}
}
\description{
This function computes the Matthews Correlation Coefficient (MCC) parity metric
}
\details{
This function computes the Matthews Correlation Coefficient (MCC) parity metric. In the returned
named vector, the reference group will be assigned 1, while all other groups will be assigned values
according to whether their Matthews Correlation Coefficients are lower or higher compared to the reference group. Lower
Matthews Correlation Coefficients rates will be reflected in numbers lower than 1 in the returned named vector, thus numbers
lower than 1 mean WORSE prediction for the subgroup.
}
\examples{
data(compas)
mcc_parity(data = compas, outcome = 'Two_yr_Recidivism', group = 'ethnicity',
probs = 'probability', preds = NULL, preds_levels = c('no', 'yes'),
cutoff = 0.4, base = 'Caucasian')
mcc_parity(data = compas, outcome = 'Two_yr_Recidivism', group = 'ethnicity',
probs = NULL, preds = 'predicted', preds_levels = c('no', 'yes'),
cutoff = 0.5, base = 'Hispanic')

}
