% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facebook.permissions.R
\name{facebook.permissions}
\alias{facebook.permissions}
\title{Extract information about the permissions for the current user}
\usage{
facebook.permissions(token)
}
\arguments{
\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}
}
\description{
\code{facebook.permissions} retrieves informations about the permissions the current user actually has with the
current application.
}
\details{
\code{facebook.permissions} returns a character vector where each row is an action the authenticated user is granted to perform
through Facebook Graph API with the current token.
}
\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
## Getting information about current user's permissions.
load("fb_oauth")
me.permissions <- facebook.permissions(token=fb_oauth)
}

}
\seealso{
\code{\link{fbOAuth}}
}
\author{
Gabriele Baldassarre
}
