% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facebook.current.accounts.R
\name{facebook.current.accounts}
\alias{facebook.current.accounts}
\title{Get the pages the current user currently manages.}
\usage{
facebook.current.accounts(token, parameters = list(),
  n = getOption("facebook.maxitems"))
}
\arguments{
\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}

\item{parameters}{A list of parameters to be added to the Facebook Graph API query. For more information on the
accepted parameters, see: \url{https://developers.facebook.com/docs/graph-api/using-graph-api}.}

\item{n}{An integer value with the maximum number of participants to be pulled for each conversation in \code{id}. It can be set to \code{Inf} 
to pull out any participant of a given conversation and assumes the default value to \code{facebook.maxitems} global option if missing.}
}
\value{
A collection of mixed accounts in a \code{\link{FacebookMixedCollection-class}} object with the \code{id} and the \code{type} for
each element included.
}
\description{
\code{facebook.current.accounts} pulls the list of pages the current user actually manages and put into a
\code{\link{FacebookPagesCollection-class}} instance.
}
\details{
This function requires the use of a OAuth token with \code{pages_show_list}
permission granted. 

Only the \code{id} and the \code{type} is returned in a mixed collection.
In normal circumstances, \code{type} is always equal to \code{page}.
}
\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
 load("fb_oauth")
 
admin.pages <- facebook.current.accounts(fb_oauth)

extended.pages <- admin.pages \%>\% FacebookPagesCollection()

}

}
\seealso{
\code{\link{fbOAuth}}
}
\author{
Gabriele Baldassarre \url{https://gabrielebaldassarre.com}
}
