% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FacebookGroupsCollection.R
\name{FacebookGroupsCollection}
\alias{FacebookGroupsCollection}
\title{Build a collection of Facebook groups}
\usage{
FacebookGroupsCollection(id, token = NULL, parameters = list(),
  fields = c("id", "cover.fields(source)", "owner.fields(id,name)",
  "created_time", "description", "name", "link"),
  n = getOption("facebook.maxitems"), metadata = FALSE,
  .progress = create_progress_bar())
}
\arguments{
\item{id}{A character vector or a comma-delimited string of IDs or an existing Facebook Collection of any 
of the supported types (see below).}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{\link{fbOAuth}}. If token \code{NULL} and \code{id} is a collection,
use the token of the source collection. Otherwise, no query is performed
to the Facebook Graph API and an empty collection is returned.}

\item{parameters}{A list of parameters to be added to the Facebook Graph API query. For more information on the
accepted parameters, see: \url{https://developers.facebook.com/docs/graph-api/using-graph-api}.}

\item{fields}{A character vector with the fields to get for each \code{id}. If no value
for a given field is found, it will be set to \code{NULL}.}

\item{n}{If \code{id} is an iterable collection, then \code{n} is the maximum number of groups to be pulled for each element of the source collection
in \code{id}. It can be set to \code{Inf} to pull out any available public group and assumes the default value from the value
of \code{facebook.maxitems} global option if missing. If \code{id} is not a collection or cannot be iterated, the parameter is ignored.}

\item{metadata}{If set to \code{TRUE}, the metadata for each ID is pulled with the data
and the \code{type} slot is fed accordingly.
Please note that setting this to \code{TRUE} could considerably
slow down the execution time, as more queries are needed.}

\item{.progress}{progress_bar object as defined in the plyr package.
By default the \code{none} progress bar is used, which prints nothing to the console. See \link[plyr]{create_progress_bar} for details.}
}
\value{
A collection of groups in a \code{\link{FacebookGroupsCollection-class}} object.
}
\description{
Connect to Facebook Graph API, get information from a list of public Facebook groups and build a \code{\link{FacebookGroupsCollection-class}}
instance.
}
\details{
\code{FacebookGroupsCollection} is the constructor for the \code{\link{FacebookGroupsCollection-class}}.
It returns data about groups but doesn't return it member lists, although it \strong{does} return 
an approximate total count for both (depending on privacy settings of the users).
}
\section{Nesting fields}{

Due to the network-graph nature of Facebook data model,
you can specify fields details for each field nesting \code{.fields()} clauses.

For example, if you need only \code{id} and \code{source} for the \code{cover} field, this is valid among others:
\code{cover.fields(id,source)}.

Following the same philosophy, if you need only \code{id} and \code{name} for the \code{from} node
you can use \code{from.fields(id,name)}.
}

\section{Valid sources}{

Instead of a character vector, one of these collections can also be passed as parameter in \code{id}:
\itemize{
 \item{\code{\link{FacebookUsersCollection-class}} will build a collection with 
 the groups the users in the source collection belong to, assuming they granted the \code{user_managed_groups} permission.}
}
}

\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
 load("fb_oauth")
 
## Pull at most 10 groups from the current user
 fb.groups <- FacebookUsersCollection("me", fb_oauth) \%>\% FacebookGroupscollection(n = 10)

## Get the members of these groups
 fb.members <- FacebookUsersCollection(fb.groups)
 
## Convert the collection to a data frame
fb.groups.df <- as.data.frame(fb.groups)

}

}
\seealso{
\code{\link{FacebookAlbumsCollection}}, \code{\link{FacebookUsersCollection}}, \code{\link{fbOAuth}}

Other Facebook Collection Constructors: \code{\link{FacebookAlbumsCollection}},
  \code{\link{FacebookCommentsCollection}},
  \code{\link{FacebookConversationsCollection}},
  \code{\link{FacebookEventsCollection}},
  \code{\link{FacebookLikesCollection}},
  \code{\link{FacebookMessagesCollection}},
  \code{\link{FacebookPagesCollection}},
  \code{\link{FacebookPhotosCollection}},
  \code{\link{FacebookPostsCollection}},
  \code{\link{FacebookReactionsCollection}},
  \code{\link{FacebookUsersCollection}},
  \code{\link{FacebookVideosCollection}}
}
\author{
Gabriele Baldassarre \url{https://gabrielebaldassarre.com}
}
