% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FacebookEventsCollection.R
\name{FacebookEventsCollection}
\alias{FacebookEventsCollection}
\title{Build a collection of Facebook events}
\usage{
FacebookEventsCollection(id, token = NULL, parameters = list(),
  fields = c("id", "owner.fields(id,name)", "category", "description",
  "end_time", "attending_count", "declined_count", "maybe_count",
  "noreply_count", "interested_count"), n = getOption("facebook.maxitems"),
  metadata = FALSE, .progress = create_progress_bar())
}
\arguments{
\item{id}{A character vector or a comma-delimited string of IDs or an existing Facebook Collection of any 
of the supported types (see below).}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{\link{fbOAuth}}. If token \code{NULL} and \code{id} is a collection,
use the token of the source collection. Otherwise, no query is performed
to the Facebook Graph API and an empty collection is returned.}

\item{parameters}{A list of parameters to be added to the Facebook Graph API query. For more information on the
accepted parameters, see: \url{https://developers.facebook.com/docs/graph-api/using-graph-api}.}

\item{fields}{A character vector with the fields to get for each \code{id}. If no value
for a given field is found, it will be set to \code{NULL}.}

\item{n}{If \code{id} is an iterable collection, then \code{n} is the maximum number of events to be pulled for each element of the source collection
in \code{id}. It can be set to \code{Inf} to pull out any available event and assumes the default value from the value
of \code{facebook.maxitems} global option if missing. If \code{id} is not a collection or cannot be iterated, the parameter is ignored.}

\item{metadata}{If set to \code{TRUE}, the metadata for each ID is pulled with the data
and the \code{type} slot is fed accordingly.
Please note that setting this to \code{TRUE} could considerably
slow down the execution time, as more queries are needed.}

\item{.progress}{progress_bar object as defined in the plyr package.
By default the \code{none} progress bar is used, which prints nothing to the console. See \link[plyr]{create_progress_bar} for details.}
}
\value{
A collection of events in a \code{\link{FacebookEventsCollection-class}} object.
}
\description{
Connect to Facebook Graph API, get information from a list of Facebook events and build a \code{FacebookEventsCollection-class}
instance.
}
\details{
\code{FacebookEventsCollection} is the constructor for the \code{\link{FacebookEventsCollection-class}}.
It returns metadata about events but doesn't return the list of attenders by default.
}
\section{Nesting fields}{

Due to the network-graph nature of Facebook data model,
you can specify fields details for each field nesting \code{.fields()} clauses.

For example, if you need only \code{id} and \code{source} for the \code{cover} field, this is valid among others:
\code{cover.fields(id,source)}.

Following the same philosophy, if you need only \code{id} and \code{name} for the \code{from} node
you can use \code{from.fields(id,name)}.
}

\section{Valid sources}{

Instead of a character vector, one of these collections can also be passed as parameter in \code{id}:
\itemize{
 \item{\code{\link{FacebookUsersCollection-class}} will build a collection with 
 the events of the users in the source collection. By default, only the attending events are returned, but
 this behaviour can be changed using the \code{type=(attending|created|declined|maybe|not_replied)} parameter.}
 \item{\code{\link{FacebookPagesCollection-class}} will build a collection with 
 the events linked to the pages in the source collection.}
 \item{\code{\link{FacebookGroupsCollection-class}} will build a collection with 
 the events linked to the groups in the source collection.}
}
}

\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
 load("fb_oauth")
 
## Getting information about two example Facebook Pages
 fb.pages <- FacebookPagesCollection(id = c("9thcirclegames",
                                           "NathanNeverSergioBonelliEditore"), 
                                     token = fb_oauth)
 
## Pull at most 10 albums from each page
 fb.events <- FacebookEventscollection(id = fb.pages, token = fb_oauth, n = 10)
 
}

}
\seealso{
\code{\link{FacebookGroupsCollection}}, \code{\link{FacebookPagesCollection}}

Other Facebook Collection Constructors: \code{\link{FacebookAlbumsCollection}},
  \code{\link{FacebookCommentsCollection}},
  \code{\link{FacebookConversationsCollection}},
  \code{\link{FacebookGroupsCollection}},
  \code{\link{FacebookLikesCollection}},
  \code{\link{FacebookMessagesCollection}},
  \code{\link{FacebookPagesCollection}},
  \code{\link{FacebookPhotosCollection}},
  \code{\link{FacebookPostsCollection}},
  \code{\link{FacebookReactionsCollection}},
  \code{\link{FacebookUsersCollection}},
  \code{\link{FacebookVideosCollection}}
}
\author{
Gabriele Baldassarre \url{https://gabrielebaldassarre.com}
}
