% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate_key}
\alias{aggregate_key}
\title{Expand a dataset to include other levels of aggregation}
\usage{
aggregate_key(.data, .spec, ...)
}
\arguments{
\item{.data}{A tsibble.}

\item{.spec}{The specification of aggregation structure.}

\item{...}{Name-value pairs of summary functions. The name will be the
name of the variable in the result. The value should be an expression
that returns a single value like \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.

The arguments in \code{...} are automatically \link[rlang:quo]{quoted} and
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. They support \link[rlang:quasiquotation]{unquoting} and
splicing. See \code{vignette("programming")} for an introduction to
these concepts.}
}
\description{
Uses the structural specification given in \code{.spec} to aggregate a time
series. A grouped structure is specified using \code{grp1 * grp2}, and a nested
structure is specified via \code{parent / child}. Aggregating the key structure is
commonly used with forecast reconciliation to produce coherent forecasts over
some hierarchy.
}
\details{
This function is experimental, and is subject to change in the future.

The way in which the measured variables are aggregated is specified in a
similar way to how \verb{[dplyr::summarise()]} is used.
}
\examples{
library(tsibble)
tourism \%>\% 
  aggregate_key(Purpose * (State / Region), Trips = sum(Trips))

}
\seealso{
\code{\link[=reconcile]{reconcile()}}, \code{\link[=is_aggregated]{is_aggregated()}}
}
