% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagwalk.R
\name{tidy.RW}
\alias{tidy.RW}
\title{Tidy a fable model}
\usage{
\method{tidy}{RW}(x, ...)
}
\arguments{
\item{x}{An object to be converted into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}.}

\item{...}{Additional arguments to tidying method.}
}
\value{
The model's coefficients in a \code{tibble}.
}
\description{
Returns the coefficients from the model in a \code{tibble} format.
}
\examples{
as_tsibble(Nile) \%>\%
  model(NAIVE(value)) \%>\% 
  tidy()

library(tsibbledata)
aus_production \%>\% 
  model(snaive = SNAIVE(Beer ~ lag("year"))) \%>\% 
  tidy()
}
