% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_and_models.R
\docType{data}
\name{dax_model_2n}
\alias{dax_model_2n}
\title{DAX 2-state HMM with normal distributions}
\format{
An object of class \code{\link{fHMM_model}}.
}
\usage{
data("dax_model_2n")
}
\description{
A pre-computed HMM on closing prices of the DAX from 2000 to 2022
with two hidden states and normal state-dependent distributions for
demonstration purpose.
}
\details{
The model was estimated via:
\preformatted{
controls <- set_controls(
  states = 2,
  sdds   = "t(df = normal)",
  data   = list(
    file        = dax,
    date_column = "Date",
    data_column = "Close",
    logreturns  = TRUE,
    from        = "2000-01-03",
    to          = "2022-12-31"
  ),
  fit    = list(runs = 100)
)
dax_data <- prepare_data(controls)
dax_model_2n <- fit_model(dax_data)
}
}
\keyword{model}
