% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\title{Download financial data from Yahoo Finance}
\usage{
download_data(
  symbol,
  from = "1902-01-01",
  to = Sys.Date(),
  fill_dates = FALSE,
  columns = c("Date", "Open", "High", "Low", "Close", "Adj.Close", "Volume")
)
}
\arguments{
\item{symbol}{A \code{character}, the stock's symbol.

It must match the identifier on \url{https://finance.yahoo.com/}.}

\item{from}{A \code{character} in the format \code{"YYYY-MM-DD"}, setting the lower
data bound.

Must not be earlier than \code{"1902-01-01"} (default).}

\item{to}{A \code{character} in the format \code{"YYYY-MM-DD"}, setting the upper
data bound.

Default is the current date \code{Sys.date()}.}

\item{fill_dates}{Set to \code{TRUE} to fill missing dates (e.g., days at which the stock
market is closed) with \code{NA}'s.

By default, \code{fill_dates = FALSE}.}

\item{columns}{A \code{character} of requested data columns, see the details.

By default, all columns are returned.}
}
\value{
A \code{data.frame}.
}
\description{
This function downloads financial data from \url{https://finance.yahoo.com/}
and returns it as a \code{data.frame}.
}
\details{
Yahoo Finance provides historical daily data for stocks or indices.
The following data columns are available:
\itemize{
\item \code{Date}: The date.
\item \code{Open}: Opening price.
\item \code{High}: Highest price.
\item \code{Low}: Lowest price.
\item \code{Close}: Close price adjusted for splits.
\item \code{Adj.Close}: Close price adjusted for dividends and splits.
\item \code{Volume}: Trade volume.
}
}
\examples{
### 21st century DAX closing prices
data <- download_data(
  symbol = "^GDAXI", from = "2000-01-01", columns = c("Date", "Close"),
  fill_dates = TRUE
)
head(data)

}
