% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate data}
\usage{
simulate_data(controls, true_parameters, seed = NULL)
}
\arguments{
\item{controls}{An object of class \code{fHMM_controls}.}

\item{true_parameters}{An object of class \code{fHMM_parameters}, used as simulation parameters.
By default, \code{true_parameters = NULL}, i.e., sampled true parameters.}

\item{seed}{Set a seed for the data simulation.
No seed per default.}
}
\value{
A \code{list} containing the following elements:
\itemize{
\item the \code{matrix} of \code{time_points},
\item the \code{matrix} of the simulated \code{markov_chain},
\item the \code{matrix} of the simulated \code{data},
\item the \code{numeric} vector of fine-scale chunk sizes \code{T_star} if
\code{controls$hierarchy = TRUE}.
}
}
\description{
This helper function simulates data for the \{fHMM\} package.
}
\keyword{internal}
