% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_fPCA.R
\name{change_fPCA}
\alias{change_fPCA}
\title{Change Point Analysis Of Functional Data Via Dimension Reduction}
\usage{
change_fPCA(fdobj, d, M = 1000, h = 0, plot = FALSE, ...)
}
\arguments{
\item{fdobj}{A functional data object of class '\code{fd}'}

\item{d}{Number of principal components}

\item{M}{Number of monte carlo simulations to get the critical values. The default value is \code{M=1000}}

\item{h}{The window parameter for the estimation of the long run covariance kernel. The default
value is \code{h=0}, i.e., it assumes iid data}

\item{plot}{If \code{TRUE} plot of the functional data before and after the estimated change and plot of the
estimated change function is given}

\item{...}{Further arguments to pass}
}
\value{
\item{\code{pvalue}}{
An approximate p value for testing whether there is a significant change in the mean function
}
\item{\code{change}}{
Estimated change location
}
\item{\code{DataBefore}}{
Data before the estimated change
}
\item{\code{DataAfter}}{
Data after the estimated change
}
\item{\code{MeanBefore}}{
Mean function before the estimated change
}
\item{\code{MeanAfter}}{
Mean function after the estimated change
}
\item{\code{change_fun}}{
Estimated change function
}
}
\description{
This function tests whether there is a significant change in the mean function of functional data, and it gives an estimate
of the location of the change. The procedure will reduce the dimension of the functional data using functional
principal component analysis and will use \code{d} leading principal curves to carry out the change point
analysis. The projection dimension \code{d} can be chosen via total variation explained (TVE) using the function
\code{\link{pick_dim}}.
}
\details{
This functions performs structural break analysis for the functional data using an fPCA based initial dimension reduction. It
is recommended that the dimension of the subspace, \code{d}, that the functional observations are projected onto should be selected based on
TVE using \code{\link{pick_dim}}.
}
\examples{
# generate functional data
fdata = fun_IID(n=100, nbasis=21)
# insert an artifiical change
data_c = insert_change(fdata, k=21, change_location = 0.5, SNR=1)$fundata
d.hat = pick_dim(data_c, 0.9)$d
change_fPCA(data_c, d=d.hat)$change
}
\references{
Berkes, I., Gabrys, R.,Hovarth, L. & P. Kokoszka (2009)., \emph{Detecting changes in the mean of functional observations}
Journal of the Royal Statistical Society, Series B 71, 927–946

Aue, A., Gabrys, R.,Hovarth, L. & P. Kokoszka (2009)., \emph{Estimation of a change-point in the mean function
of functional data}Journal of Multivariate Analysis 100, 2254–2269.
}
\seealso{
\code{\link{change_FF}}
}
