% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/area_plot.R
\name{area_plot}
\alias{area_plot}
\title{area_plot}
\usage{
area_plot(
  data,
  x,
  y = "1",
  group = NULL,
  facet_x = NULL,
  facet_y = NULL,
  size = 11,
  reorder = c("group", "facet_x", "facet_y"),
  palette = ez_col,
  labels_y = if (position == "fill") {     function(x) ez_labels(100 * x, append =
    "\%") } else {     ez_labels },
  labels_x = NULL,
  use_theme = theme_ez,
  position = c("stack", "fill"),
  facet_scales = "fixed",
  facet_ncol = NULL,
  legend_ncol = NULL,
  env = parent.frame()
)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{y}{A named character value. Evaluates to a column.}

\item{group}{A character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{facet_y}{A character. Evaluates to a column.}

\item{size}{theme size for \code{use_theme()}. Default is 14.}

\item{reorder}{A character vector specifying the group variables to reorder.
Default is \code{c("group", "facet_x", "facet_y")}.}

\item{palette}{Colour function.}

\item{labels_y}{label formatting function}

\item{labels_x}{label formatting function}

\item{use_theme}{ggplot theme function}

\item{position}{Either \code{"stack"} (default) or \code{"fill"}}

\item{facet_scales}{Option passed to scales argument in \code{facet_wrap} or
\code{facet_grid}. Default is \code{"fixed"}.}

\item{facet_ncol}{Option passed to ncol argument in \code{facet_wrap} or
\code{facet_grid}. Default is \code{NULL}.}

\item{legend_ncol}{Number of columns in legend.}

\item{env}{environment for evaluating expressions.}
}
\value{
A ggplot object.
}
\description{
Aggregates a data.frame and creates a stacked area chart.
}
\examples{
\donttest{
library(tsibble)
library(tsibbledata)
area_plot(ansett, x = "as.Date(Week)", y = "Passengers")
area_plot(ansett,
          x = "as.Date(Week)", y = c("Weekly Passengers" = "Passengers"), "Class")
area_plot(ansett, "as.Date(Week)",
          y = c("Weekly Passengers" = "Passengers"),
          group = "substr(Airports, 5, 7)",
          facet_x = "substr(Airports, 1, 3)",
          facet_y = "Class",
          facet_scales = "free_y")
}
}
