% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ezcox.R
\name{ezcox}
\alias{ezcox}
\title{Run Cox Analysis in Batch Mode}
\usage{
ezcox(
  data,
  covariates,
  controls = NULL,
  time = "time",
  status = "status",
  global_method = c("likelihood", "wald", "logrank"),
  keep_models = FALSE,
  return_models = FALSE,
  model_dir = file.path(tempdir(), "ezcox"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} containing variables, time and os status.}

\item{covariates}{column names specifying variables.}

\item{controls}{column names specifying controls.}

\item{time}{column name specifying time, default is 'time'.}

\item{status}{column name specifying event status, default is 'status'.}

\item{global_method}{method used to obtain global p value for cox model,
should be one of "likelihood", "wald", "logrank".
The likelihood-ratio test, Wald test, and score logrank statistics.
These three methods are asymptotically equivalent. For large enough N,
they will give similar results. For small N, they may differ somewhat.
The Likelihood ratio test has better behavior for small sample sizes,
so it is generally preferred.}

\item{keep_models}{If \code{TRUE}, keep models as local files.}

\item{return_models}{default \code{FALSE}. If \code{TRUE}, return a \code{list} contains
cox models.}

\item{model_dir}{a path for storing model results.}

\item{verbose}{if \code{TRUE}, print extra info.}

\item{...}{other parameters passing to \code{\link[survival:coxph]{survival::coxph()}}.}
}
\value{
a \code{ezcox} object
}
\description{
Run Cox Analysis in Batch Mode
}
\examples{
library(survival)

# Build unvariable models
ezcox(lung, covariates = c("age", "sex", "ph.ecog"))

# Build multi-variable models
# Control variable 'age'
ezcox(lung, covariates = c("sex", "ph.ecog"), controls = "age")

# Return models
ezcox(lung,
  covariates = c("age", "sex", "ph.ecog"),
  return_models = TRUE
)
ezcox(lung,
  covariates = c("sex", "ph.ecog"), controls = "age",
  return_models = TRUE
)
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
