% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_prep.R
\name{make_eyetrackingr_data}
\alias{make_eyetrackingr_data}
\title{Convert raw data for use in eyetrackingR}
\usage{
make_eyetrackingr_data(data, participant_column, trackloss_column, time_column,
  trial_column, aoi_columns, treat_non_aoi_looks_as_missing,
  item_columns = NULL)
}
\arguments{
\item{data}{Your original data. See details section below.}

\item{participant_column}{Column name for participant identifier}

\item{trackloss_column}{Column name indicating trackloss}

\item{time_column}{Column name indicating time}

\item{trial_column}{Column name indicating trial identifier}

\item{aoi_columns}{Names of AOIs}

\item{treat_non_aoi_looks_as_missing}{This is a logical indicating how you would like to perform
"proportion-looking" calculations, which are central to eyetrackingR's eyetracking analyses. If set to
TRUE, any samples that are not in any of the AOIs (defined with the \code{aoi_columns} 
argument) are treated as missing data; when it comes time for eyetrackingR to calculate 
proportion looking to an AOI, this will be calculated as "time looking to that AOI divided by 
time looking to all other AOIs." In contrast, if this parameter is set to FALSE, proportion 
looking to an AOI will be calculated as "time looking to that AOI divided by total time 
looking."}

\item{item_columns}{Column names indicating items (optional)}
}
\value{
Dataframe ready for use in eyetrackingR.
}
\description{
This should be the first function you use when using eyetrackingR for a project (potentially with
the exception of `add_aoi`, if you need to add AOIs). This function takes your raw dataframe, as 
well as information about your dataframe. It confirms that all the columns are the right format, 
based on this information. Further if \code{treat_non_aoi_looks_as_missing} is set to TRUE, it 
converts non-AOI looks to missing data (see the "Preparing your data" vignette for more 
information).
}
\details{
eyetrackingR is designed to deal with data in a (relatively) raw form,
where each row specifies a sample. Each row should represent an equally spaced unit of time
(e.g., if your eye-tracker's sample rate is 100hz, then each row corresponds to the
eye-position every 10ms). This is in contrast to the more parsed data that the software bundled
with eye-trackers can sometimes output (e.g., already parsed into saccades or fixations). For
eyetrackingR, the simplest data is the best. This also maximizes compatibility: eyetrackingR
will work with any eye-tracker's data (e.g., Eyelink, Tobii, etc.), since it requires the most
basic format.
}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE
)
  
}
