% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/onset_contingent_data.R
\name{make_onset_data}
\alias{make_onset_data}
\title{Make onset-contingent data.}
\usage{
make_onset_data(data, onset_time, fixation_window_length, target_aoi,
  distractor_aoi = NULL)
}
\arguments{
\item{data}{The original (verified) data}

\item{onset_time}{When to check for participants' "starting" AOI?}

\item{fixation_window_length}{Which AOI is currently being fixated is determined by taking a rolling
average. This is the width of window for rolling average.}

\item{target_aoi}{Which AOI is the target that should be switched *to*}

\item{distractor_aoi}{Which AOI is the distractor that should be switched *from* (default = !target_aoi)}
}
\value{
Original dataframe augmented with column indicating switch away from target AOI
}
\description{
Divide trials into which AOI participants started on. Calculate switches away from this AOI, using
a rolling window to determine what length consitutes a switch. Augment original data with a column
indicating whether each row is a switch-away sample.
}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition,
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE
)
response_window <- subset_by_window(data, window_start_time = 15500, window_end_time = 21000,
                                    rezero = FALSE)
inanimate_trials <- subset(response_window, grepl('(Spoon|Bottle)', Trial))
onsets <- make_onset_data(inanimate_trials, onset_time = 15500,
                          fixation_window_length = 100, target_aoi='Inanimate')
}

