% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{plot.radf}
\alias{plot.radf}
\title{Plotting}
\usage{
\method{plot}{radf}(x, y, option = c("gsadf", "sadf"), min_duration = 0,
  plot_type = c("multiple", "single"), breaks_x = NULL,
  format_date = "\%m-\%Y", breaks_y = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{\link[=radf]{radf()}}.}

\item{y}{An object, which is the output of \code{\link[=mc_cv]{mc_cv()}} or
\code{\link[=wb_cv]{wb_cv()}}.}

\item{option}{Whether to apply the "gsadf" or "sadf" methodology. Default is
"gsadf".}

\item{min_duration}{The minimum duration of an explosive period for it to be
reported. Default is 0.}

\item{plot_type}{For multivariate \code{radf} objects, "multiple" plots the series
on multiple plots and "single" superimposes them on a single plot
datestamping only the period of explosiveness. Default is "multiple".}

\item{breaks_x}{optional, determines the breaks on the x-axis.}

\item{format_date}{A character string, optional, determines the format of the
date on the plot when the index is of class `Date'.}

\item{breaks_y}{Optional, determines the breaks on the y-axis.}

\item{...}{Additional graphical arguments passed on to methods. Currently
not used.}
}
\value{
A list of ggplot objects.
}
\description{
Plotting method for objects of class \code{\link[=radf]{radf()}}.
}
\details{
\itemize{
  \item{\code{breaks_x}: }{A scalar for continuous variable that will feed into
  \code{scale_x_date}/ or a date period ("week", "month", "year") or
  multiples ("6 months", "2 years") thereof that will feed into
  \code{scale_x_continuous}}.
  \item{\code{format_date}: }{The format_date and the format in a radf object can
  be different. User can specify the format here.}
  \item{\code{breaks_y}: }{A scalar for continuous variables which generates breaks
  for points at which y gridlines will appear (see \code{scale_y_continuous}).}
}
}
\examples{
\donttest{
# Simulate bubble processes, compute t-stat and critical values and summarize
set.seed(4441)
dta <- cbind(sim_dgp1(n = 100), sim_dgp2(n = 100))
rfd <- radf(x = dta)
mc <- mc_cv(n = 100)
plot(x = rfd, y = mc)

# Plot the graphs in one plot
library(gridExtra)
p1 <- plot(x = rfd, mc)
do.call(grid.arrange, c(p1, ncol = 2))

#Plot in a single graph
plot(x = rfd, y = mc, plot_type = "single")
}
}
