% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouping.R
\name{by_groups}
\alias{by_groups}
\title{Aggregate dataset by grouping variable(s).}
\usage{
by_groups(data, ...)
}
\arguments{
\item{data}{data for aggregation}

\item{...}{aggregation parameters. Character/numeric or criteria/logical functions (see
\link{criteria}) for grouping variables and formulas with aggregation expressions, 
such as \code{mean_x ~ mean(x)}. Names of variables at the top-level can be unquoted (non-standard
evaluation). For standard evaluation of parameters you can surround them by
round brackets. See examples. Instead of the formulas it can be single 
function as last argument - it will be applied to all non-grouping columns.}
}
\value{
aggregated data.frame/data.table
}
\description{
Splits the data by groups, computes summary statistics for each, and returns
\code{data.frame}/\code{data.table}.
}
\examples{
# compute mean of the every column for every value of the Species
data(iris)
by_groups(iris, Species, mean)

# compute mean of the every numeric column
iris \%>\% except(Species) \%>\% by_groups(mean)

# compute different functions for different columns
# automatic naming
data(mtcars)
by_groups(mtcars, cyl, am, ~ mean(hp), ~ median(mpg))

# with custom names
by_groups(mtcars, cyl, am, mean_hp ~ mean(hp), median_mpg ~ median(mpg))

# variable substitution
group1 = "cyl"
statistic1 = ~ mean(hp)
by_groups(mtcars, (group1), (statistic1))

group2 = "am"
# formulas can be easily constructed from text strings
statistic2 = as.formula("~ median(mpg)") 
by_groups(mtcars, (group2), (statistic2))

by_groups(mtcars, (group1), (group2), (statistic1), (statistic2))


}
