% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2-conjoin.R
\docType{methods}
\name{conjoin}
\alias{conjoin}
\alias{conjoin,ExprsArray-method}
\alias{conjoin,ExprsEnsemble-method}
\alias{conjoin,ExprsModel-method}
\alias{conjoin,ExprsPipeline-method}
\title{Combine \code{exprso} Objects}
\usage{
conjoin(object, ...)

\S4method{conjoin}{ExprsArray}(object, ...)

\S4method{conjoin}{ExprsModel}(object, ...)

\S4method{conjoin}{ExprsPipeline}(object, ...)

\S4method{conjoin}{ExprsEnsemble}(object, ...)
}
\arguments{
\item{object}{An \code{ExprsArray}, \code{ExprsModel}, \code{ExprsPipeline}, or
\code{ExprsEnsemble} object.}

\item{...}{Two or more objects of the same class.}
}
\description{
\code{conjoin} combines two or more \code{exprso} objects based on their class.
}
\details{
When applied to two or more \code{ExprsArray} objects, this function returns one
 \code{ExprsArray} object as output. This only works on \code{ExprsArray} objects
 that have not undergone feature selection. Any missing annotations in \code{@annot}
 will get replaced with \code{NA} values. Note that all combined \code{ExprsArray}
 objects must initially have had the same features in the same order.

When applied to two or more \code{ExprsModel} objects, this function returns one
 \code{ExprsEnsemble} object as output. In this way, this function works similar to
 the \code{\link{buildEnsemble}} method for \code{ExprsModel} objects.

When applied to two or more \code{ExprsPipeline} objects, this function returns one
 \code{ExprsPipeline} object as output. To keep track of which \code{ExprsPipeline}
 objects contributed initially to the resultant object, the source gets flagged in
 the \code{summary} slot. For each \code{ExprsPipeline} object, if the \code{summary}
 lacks a \code{boot} column, all \code{summary} entries will receive one unique ID.
 However, if the \code{summary} contains a \code{boot} column (e.g., as generated by
 \code{\link{plMonteCarlo}}), all models belonging to each bootstrap will receive
 one unique ID. Afterwards, the old \code{boot} columns will get renamed to \code{unboot}
 while the newly assigned unique IDs become the new \code{boot} column. This
 complicated indexing system treats all models derived from one unique cut to a
 training set as if they had belonged to the same "pseudo-bootstrap". These "pseudo-bootstraps"
 will get handled like true bootstraps downstream by functions built around
 \code{\link{pipeFilter}} and \code{\link{buildEnsemble}}.

When applied to two or more \code{ExprsEnsemble} objects, this function returns one
 \code{ExprsEnsemble} object as output. The resultant object contains all classification
 models found within each of the supplied \code{ExprsEnsemble} objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{ExprsArray}: Method to join \code{ExprsArray} objects.

\item \code{ExprsModel}: Method to join \code{ExprsModel} objects.

\item \code{ExprsPipeline}: Method to join \code{ExprsPipeline} objects.

\item \code{ExprsEnsemble}: Method to join \code{ExprsEnsemble} objects.
}}
\seealso{
\code{\link{ExprsArray-class}}\cr
\code{\link{ExprsModel-class}}\cr
\code{\link{ExprsPipeline-class}}\cr
\code{\link{ExprsEnsemble-class}}\cr
\code{\link{ExprsPredict-class}}
}

