% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_year_pubs.R
\name{get_year_pubs}
\alias{get_year_pubs}
\title{Secondary function to transform data generated with powoSpecies}
\usage{
get_year_pubs(inputdf = NULL,
              verbose = TRUE,
              save = FALSE,
              dir = "results_POWO_with_year_pubs",
              filename = "POWO_with_year_pubs")
}
\arguments{
\item{inputdf}{A dataframe generated using \code{powoSpecies} function with
the argument synonyms set as \code{TRUE} and containing the genus and species
column and the associated information about the protologue of each species.
The species name must be binomial, i.e. must contain both the genus name and
specific epithet.}

\item{verbose}{Logical, if \code{FALSE}, a message showing each step during
the POWO search will not be printed in the console in full.}

\item{save}{Logical, if \code{TRUE}, the transformed input POWO database
will be saved on disk.}

\item{dir}{Pathway to the computer's directory, where the file will be saved
provided that the argument \code{save} is set up in \code{TRUE}. The default
is to create a directory named \strong{results_POWO_with_year_pubs} and the search
results will be saved within a subfolder named after the current date.}

\item{filename}{Name of the output file to be saved. The default is to create
a file entitled \strong{POWO_with_year_pubs}.}
}
\value{
Objects of class dataframe and saves the output on disk.
}
\description{
Produces a spreadsheet with extra data about the
publication, adding the corrected year of publication and the counting of
synonyms of each species. It is an optional function to be used after run
expowo's \code{powoSpecies} and to use as input data in the expowo's
\code{accGraph}.
}
\examples{
\dontrun{

library(expowo)

output <- powoSpecies(family = "Fabaceae",
                      genus = NULL,
                      synonyms = TRUE,
                      country = NULL,
                      save = FALSE,
                      dir = "Fabaceae_results_powoSpecies",
                      filename = "Fabaceae_spp")


output_year_pubs <- get_year_pubs(inputdf = output,
                                  verbose = TRUE,
                                  save = FALSE,
                                  dir = "results_POWO_with_year_pubs",
                                  filename = "POWO_with_year_pubs")
}

}
\seealso{
\code{\link{megaGen}}

\code{\link{powoSpecies}}

\code{\link{powoFam}}

\code{\link{powoGenera}}

\code{\link{accGraph}}
}
\author{
Debora Zuanny & Domingos Cardoso
}
