% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_num.R
\name{evaluate_sd}
\alias{evaluate_sd}
\title{Evaluates the mean of the numeric values}
\usage{
evaluate_sd(i, pheno)
}
\arguments{
\item{i}{List of indices}

\item{pheno}{Data.frame with the samples}
}
\value{
A matrix with the standard deviation value for each column for each
subset
}
\description{
Looks for the standard deviation of the numeric values
}
\examples{
data(survey, package = "MASS")
index <- design(survey[, c("Sex", "Smoke", "Age")], size_subset = 50,
                iterations = 50)
# Note that categorical columns will be omitted:
evaluate_sd(index, survey[, c("Sex", "Smoke", "Age")])
}
\seealso{
Other functions to evaluate samples: 
\code{\link{evaluate_entropy}()},
\code{\link{evaluate_independence}()},
\code{\link{evaluate_index}()},
\code{\link{evaluate_mad}()},
\code{\link{evaluate_mean}()},
\code{\link{evaluate_na}()},
\code{\link{evaluate_orig}()}

Other functions to evaluate numbers: 
\code{\link{evaluate_mad}()},
\code{\link{evaluate_mean}()},
\code{\link{evaluate_na}()}
}
\concept{functions to evaluate numbers}
\concept{functions to evaluate samples}
