/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.utils.AFtimesCopyNumber;
import core.utils.Common;
import core.utils.CopyNumber;
import core.utils.NotAValidCompositionException;
import java.util.HashSet;

public class Subpopulation {
    private int pm;
    private int pmb;
    private double f;
    private Subpopulation parent;
    private Subpopulation child;
    private Subpopulation sibling;
    private double deviation;

    public Subpopulation(double f, int pm, int pmb, Subpopulation parent) throws NotAValidCompositionException {
        if (f < 0.0 || f > 1.0) {
            throw new IllegalArgumentException("A cellular frequency must be between 0 and 1.");
        }
        if (pm < 0) {
            throw new IllegalArgumentException("Subpopulation's ploidy must be >= 0.");
        }
        if (pmb < 0) {
            throw new IllegalArgumentException("Subpopulation's mutated allele ploidy must be >= 0.");
        }
        if (pmb > pm) {
            throw new IllegalArgumentException("Subpopulation's mutated allele ploidy can't exceed its total ploidy.");
        }
        this.parent = parent;
        this.f = f;
        this.pm = pm;
        this.pmb = pmb;
        if (parent != null && !this.isValidAsSomatic()) {
            throw new NotAValidCompositionException();
        }
    }

    private boolean isValidAsSomatic() {
        boolean c2;
        boolean bl = c2 = this.pm != this.getRoot().pm;
        if (c2) {
            return true;
        }
        boolean c1 = this.pmb / this.pm > this.getRoot().pmb / this.getRoot().pm;
        return c1;
    }

    public Subpopulation getRoot() {
        Subpopulation root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public HashSet<Subpopulation> getPotentialParents(AFtimesCopyNumber afxcn) {
        HashSet<Subpopulation> sps = new HashSet<Subpopulation>();
        if (this.pm == this.getRoot().pm) {
            return sps;
        }
        Double[] freqs = Common.above(this.f, Common.allowed_FREQUENCIES);
        int PM = 2;
        Double[] doubleArray = freqs;
        int n = freqs.length;
        int n2 = 0;
        while (n2 < n) {
            double pf = doubleArray[n2];
            Double[] doubleArray2 = Common.seq(1.0, PM, 1.0);
            int n3 = doubleArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                double pmb = doubleArray2[n4];
                try {
                    Subpopulation s = new Subpopulation(pf, PM, (int)pmb, this.getRoot());
                    s.setChild(this);
                    s.deviation = Math.abs(afxcn.getValue() - ((double)s.pmb * (s.f - s.child.f) + (double)s.child.pmb * s.child.f + (double)this.getRoot().pmb * (1.0 - s.f)));
                    sps.add(s);
                }
                catch (NotAValidCompositionException notAValidCompositionException) {
                    // empty catch block
                }
                ++n4;
            }
            ++n2;
        }
        return sps;
    }

    public HashSet<Subpopulation> getPotentialSiblings(AFtimesCopyNumber afxcn) {
        Double[] freqs;
        HashSet<Subpopulation> sps = new HashSet<Subpopulation>();
        if (this.pmb > 0) {
            return sps;
        }
        Double[] doubleArray = freqs = Common.below(1.0 - this.f, Common.allowed_FREQUENCIES);
        int n = freqs.length;
        int n2 = 0;
        while (n2 < n) {
            double pf = doubleArray[n2];
            Double[] doubleArray2 = Common.seq(1.0, 2.0, 1.0);
            int n3 = doubleArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                double pmb = doubleArray2[n4];
                try {
                    Subpopulation s = new Subpopulation(pf, 2, (int)pmb, this.getRoot());
                    s.setSibling(this);
                    s.deviation = Math.abs(afxcn.getValue() - ((double)s.pmb * s.f + (double)this.getRoot().pmb * (1.0 - s.f)));
                    sps.add(s);
                }
                catch (NotAValidCompositionException notAValidCompositionException) {
                    // empty catch block
                }
                ++n4;
            }
            ++n2;
        }
        return sps;
    }

    public HashSet<Subpopulation> getPotentialChildren(AFtimesCopyNumber afxcn) {
        Double[] freqs;
        HashSet<Subpopulation> sps = new HashSet<Subpopulation>();
        Double[] doubleArray = freqs = Common.below(this.f, Common.allowed_FREQUENCIES);
        int n = freqs.length;
        int n2 = 0;
        while (n2 < n) {
            double pf = doubleArray[n2];
            Double[] doubleArray2 = Common.seq(Math.max(1, this.pmb), this.pm, 1.0);
            int n3 = doubleArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                double pmb = doubleArray2[n4];
                try {
                    Subpopulation s = new Subpopulation(pf, this.pm, (int)pmb, this.getRoot());
                    s.setParent(this);
                    s.deviation = Math.abs(afxcn.getValue() - ((double)s.pmb * s.f + (double)this.getRoot().pmb * (1.0 - s.f)));
                    sps.add(s);
                }
                catch (NotAValidCompositionException notAValidCompositionException) {
                    // empty catch block
                }
                ++n4;
            }
            ++n2;
        }
        return sps;
    }

    public HashSet<Subpopulation> getPotentialChildren(CopyNumber cn) {
        Double[] freqs;
        HashSet<Subpopulation> sps = new HashSet<Subpopulation>();
        Double[] doubleArray = freqs = Common.below(this.f, Common.allowed_FREQUENCIES);
        int n = freqs.length;
        int n2 = 0;
        while (n2 < n) {
            double pf = doubleArray[n2];
            Double[] doubleArray2 = Common.seq(this.pmb, Common.MAX_PM, 1.0);
            int n3 = doubleArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                double pm = doubleArray2[n4];
                double dev = Math.abs(cn.getValue() - (pm * pf + (double)this.getRoot().pm * (1.0 - pf)));
                Double[] doubleArray3 = Common.seq(this.pmb, pm, 1.0);
                int n5 = doubleArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    double pmb = doubleArray3[n6];
                    try {
                        Subpopulation s1 = new Subpopulation(pf, (int)pm, (int)pmb, this);
                        s1.setParent(this);
                        s1.deviation = dev;
                        sps.add(s1);
                    }
                    catch (NotAValidCompositionException notAValidCompositionException) {
                        // empty catch block
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return sps;
    }

    public boolean equals(Object o) {
        if (o instanceof Subpopulation) {
            Subpopulation os = (Subpopulation)o;
            if (os.f == this.f && os.pm == this.pm && os.pmb == this.pmb) {
                if (this.parent != null ? !this.parent.equals(os.parent) : os.parent != null) {
                    return false;
                }
                return !(this.child != null ? !this.child.equals(os.child) : os.child != null);
            }
        }
        return false;
    }

    public boolean shallowEquals(Subpopulation os) {
        return os.pm == this.pm && os.pmb == this.pmb;
    }

    private void setParent(Subpopulation subpopulation) throws NotAValidCompositionException {
        if (subpopulation.f < this.f) {
            throw new IllegalArgumentException("Parent can't be smaller than its child's subpopulation size");
        }
        if (subpopulation.f == this.f && !this.shallowEquals(subpopulation) || subpopulation.f != this.f && this.shallowEquals(subpopulation)) {
            throw new NotAValidCompositionException();
        }
        this.parent = subpopulation;
    }

    private void setSibling(Subpopulation subpopulation) throws NotAValidCompositionException {
        if (subpopulation.f + this.f > 1.0) {
            throw new IllegalArgumentException("Two siblings' cummulative cellular frequency cannot exceed 1");
        }
        if (subpopulation.f == this.f && !this.shallowEquals(subpopulation) || subpopulation.f != this.f && this.shallowEquals(subpopulation)) {
            throw new NotAValidCompositionException();
        }
        this.sibling = subpopulation;
    }

    private void setChild(Subpopulation subpopulation) throws NotAValidCompositionException {
        if (subpopulation.f > this.f) {
            throw new IllegalArgumentException("Child can't be larger than its parent subpopulation size");
        }
        if (subpopulation.f == this.f && !this.shallowEquals(subpopulation) || subpopulation.f != this.f && this.shallowEquals(subpopulation)) {
            throw new NotAValidCompositionException();
        }
        this.child = subpopulation;
    }

    public double getCellularFrequency() {
        return this.f;
    }

    public double getDeviation() {
        return Math.max(Double.MIN_NORMAL, this.deviation);
    }

    public Subpopulation getChild() {
        return this.child;
    }

    public Subpopulation getSibling() {
        return this.sibling;
    }

    public Subpopulation getParent() {
        return this.parent;
    }

    public int getPm() {
        return this.pm;
    }

    public int getPmb() {
        return this.pmb;
    }

    public String toString() {
        return String.valueOf(this.f) + ":pm=" + this.pm + ";pmb=" + this.pmb;
    }

    public double eventsTo(Subpopulation sp) {
        int mut_d = sp.pmb - this.pmb;
        int d = sp.pm - this.pm;
        if (mut_d == d) {
            return 1.0 * (double)Math.abs(mut_d);
        }
        return 1.0 * (double)Math.abs(d) + (double)Math.abs(mut_d);
    }
}

