% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{exclude_duration}
\alias{exclude_duration}
\title{Exclude rows with minimum or maximum durations}
\usage{
exclude_duration(
  x,
  min_duration = 10,
  max_duration = NULL,
  id_col = "ResponseId",
  duration_col = "Duration (in seconds)",
  quiet = TRUE,
  print = TRUE,
  silent = FALSE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{min_duration}{Minimum duration that is too fast in seconds.}

\item{max_duration}{Maximum duration that is too slow in seconds.}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{duration_col}{Column name for durations.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}

\item{silent}{Logical indicating whether to print message to console. Note
this argument controls the exclude message not the check message.}
}
\value{
An object of the same type as \code{x} that excludes rows
with fast and/or slow duration.
For a function that checks for these rows, use \code{\link[=check_duration]{check_duration()}}.
For a function that marks these rows, use \code{\link[=mark_duration]{mark_duration()}}.
}
\description{
The \code{exclude_duration()} function removes
rows of data that have durations that are too fast or too slow.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
By default, minimum durations of 10 seconds are checked, but either
minima or maxima can be checked with the \code{min_duration} and
\code{max_duration} arguments. The function outputs to console separate
messages about the number of rows that are too fast or too slow.

This function returns the fast and slow rows.
}
\examples{
# Exclude durations faster than 100 seconds
data(qualtrics_text)
df <- exclude_duration(qualtrics_text, min_duration = 100)

# Remove preview data first
df <- qualtrics_text \%>\%
  exclude_preview() \%>\%
  exclude_duration()

# Exclude only for durations slower than 800 seconds
df <- qualtrics_text \%>\%
  exclude_preview() \%>\%
  exclude_duration(max_duration = 800)
}
\seealso{
Other duration functions: 
\code{\link{check_duration}()},
\code{\link{mark_duration}()}

Other exclude functions: 
\code{\link{exclude_duplicates}()},
\code{\link{exclude_ip}()},
\code{\link{exclude_location}()},
\code{\link{exclude_preview}()},
\code{\link{exclude_progress}()},
\code{\link{exclude_resolution}()}
}
\concept{duration functions}
\concept{exclude functions}
