\name{exams2openolat}
\alias{exams2openolat}

\title{Generation of Exams for OpenOLAT}

\description{
  Automatic generation of exams in QTI 2.1 (or 1.2) with some
  tweaks optimized for OpenOLAT.
}

\usage{
  exams2openolat(file, n = 1L, dir = ".", name = "olattest",
  qti = "2.1", converter = "pandoc-mathjax", \dots)
}

\arguments{
  \item{file}{character. A specification of a (list of) exercise files.}
  \item{n}{integer. The number of copies to be compiled from \code{file}.}
  \item{dir}{character. The default is the current working directory.}
  \item{name}{character. A name prefix for resulting exercises and ZIP file.}
  \item{qti}{character indicating whether QTI \code{"1.2"} or \code{"2.1"}
    (default) should be generated.}
  \item{converter}{character passed on to \code{\link[exams]{make_exercise_transform_html}},
    indicating the type of converter from LaTeX/Markdown to HTML. Defaults
    to HTML with MathJax (and OpenOLAT-specific fixups).}
  \item{\dots}{arguments passed on to \code{\link[exams]{exams2qti12}} or
    \code{\link[exams]{exams2qti21}}, respectively.}
}

\details{
  \code{exams2openolat} is a convenience interface to \code{\link[exams]{exams2qti12}}
  and \code{\link[exams]{exams2qti21}} for generating either QTI 1.2 or 2.1
  (default) output with some small tweaks for OpenOLAT. Specifically, the MathJax
  output from pandoc is post-processed as expected by OpenOLAT.
}

\value{
  \code{exams2openolat} returns a list of exams as generated by \code{\link[exams]{xexams}}.
}

\seealso{
  \code{\link[exams]{exams2qti12}},
  \code{\link[exams]{exams2qti12}}
}

\examples{
## load package and enforce par(ask = FALSE)
library("exams")
options(device.ask.default = FALSE)

## define an exams (= list of exercises)
myexam <- list(
  "boxplots",
  c("tstat", "ttest", "confint"),
  c("regression", "anova"),
  c("scatterplot", "boxhist"),
  "relfreq"
)

## output directory
mydir <- tempdir()

## generate .zip with OpenOLAT test in temporary directory
exams2openolat(myexam, n = 3, dir = mydir)
dir(mydir)
}

\keyword{utilities}
