% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis_latex.R
\name{hypothesis_latex}
\alias{hypothesis_latex}
\alias{lhypo}
\title{Latex Hypothesis}
\usage{
hypothesis_latex(
  left,
  alternative = NULL,
  null = NULL,
  right = paste0(left, "_0")
)

lhypo(left, alternative = NULL, null = NULL, right = paste0(left, "_0"))
}
\arguments{
\item{left}{character: symbol, for example \code{"\\mu"} or \code{"\\pi"}}

\item{alternative}{character: alternative hypotheses}

\item{null}{character: null hypotheses (default: \code{NULL})}

\item{right}{character: a symbol (default: \code{paste0(left, "_0")})}
}
\value{
A data frame with hypothesis pairs.
}
\description{
Creates a data frame for a test hypothesis with various columns:
\itemize{
\item \code{h0.left} left value of the null hypothesis, usually \verb{\\mu} or \verb{\\pi}
\item \code{h0.operator} operator of the null hypothesis, one of the following: \code{eq}, \code{ne}, \code{lt}, \code{le}, \code{gt}, or \code{ge}
\item \code{h0.right} right value of the null hypothesis, usually \verb{\\mu_0}, \verb{\\pi_0}, or a hypothetical value
\item \code{h1.left} left value of the alternative hypothesis, usually \verb{\\mu} or \verb{\\pi}
\item \code{h1.operator} operator of the alternative hypothesis, one of the following: \code{eq}, \code{ne}, \code{lt}, \code{le}, \code{gt}, or \code{ge}
\item \code{h1.right} right value of the alternative hypothesis, usually \verb{\\mu_0}, \verb{\\pi_0}, or a hypothetical value
\item \code{H0} latex representation of the null hypothesis
\item \code{H1} latex representation of the alternative hypothesis
\item \code{match.left} do the left value in the null and the alternative hypothesis match?
\item \code{match.right}  do the right value in the null and the alternative hypothesis match?
\item \code{match.operator} do the operators in the null and the alternative hypothesis cover all real numbers?
\item \code{match.right}  do the right value in the null and alternative hypothesis match?
\item \code{match.type} either \code{wrong}, \code{left.sided}, \code{right.sided}, \code{two.sided}, \code{greater}, or \code{less}.
}

If \code{null} is not given then it is determined from \code{alternative}. Otherwise hypotheses pairs are generated by
all combinations from \code{alternative} and \code{null}.
Valid values for \code{alternative}and \code{null} are \code{two.sided}, \code{greater}, \code{less},  \code{eq}, \code{ne}, \code{lt}, \code{le}, \code{gt}, or \code{ge}.
}
\examples{
# Create one hypotheses pair
hypothesis_latex("\\\\mu")
hypothesis_latex("\\\\pi")
hypothesis_latex("\\\\mu", alternative="two.sided")
hypothesis_latex("\\\\mu", alternative="two.sided", null="lt")
hypothesis_latex("\\\\mu", alternative="ne", null="eq")
hypothesis_latex("\\\\mu", right=c(0,1))
hypothesis_latex("\\\\mu", alternative=c("eq", "ne", "lt", "le", "gt", "ge"))
hypothesis_latex("\\\\mu", alternative=c("eq", "ne", "lt", "le", "gt", "ge"), 
                         null=c("eq", "ne", "lt", "le", "gt", "ge"))
}
