% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result.R
\name{as_result}
\alias{as_result}
\alias{as_res}
\alias{tolerance}
\alias{tol}
\alias{rounded}
\alias{val}
\alias{digits}
\title{Results with Rounding}
\usage{
as_result(x, digits, tol = NA, FUN = round2)

tol(x)

rounded(x)

val(x)

digits(x)

as_res(x, digits, tol = NA, FUN = round2)

tolerance(x)
}
\arguments{
\item{x}{numeric: value to round}

\item{digits}{integer or character: Digits that should be used for rounding or \code{"integer"} for \code{digits=0}, \code{"\%"} for \code{digits=2},  or  \code{"probability"} for \code{digits=4}. Abbreviations for the names can be used}

\item{tol}{numeric: tolerance for result}

\item{FUN}{function: rounding function (default: \code{round2})}
}
\value{
A list with the original and a rounded value, digits used and tolerance.
}
\description{
Rounds \code{x} according to \code{digits}, \code{FUN} and sets a tolerance for the result.
If the tolerance is not stated, consider it the maximum of \code{2*10^(-digits)}.
}
\examples{
x <- as_result(1/3, "prob")
tol(x)
rounded(x)
tol(x)
digits(x)
}
