% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exemplar.R
\name{make-test-shells}
\alias{make-test-shells}
\alias{make_test_shell_fun}
\alias{make_tests_shells_file}
\alias{make_tests_shells_pkg}
\title{Create test shells.}
\usage{
make_test_shell_fun(
  fun,
  pkg_dir = ".",
  overwrite = FALSE,
  e_e = TRUE,
  roxytest = FALSE,
  open = TRUE,
  document = TRUE
)

make_tests_shells_file(
  r_file_name,
  pkg_dir = ".",
  overwrite = FALSE,
  e_e = TRUE,
  open = TRUE,
  document = TRUE
)

make_tests_shells_pkg(
  pkg_dir = ".",
  overwrite = FALSE,
  e_e = TRUE,
  open = FALSE,
  document = TRUE
)
}
\arguments{
\item{fun}{The name of the function to make a test shell for.}

\item{pkg_dir}{The directory of the R project for this package (defaults to
current directory). Note that this is the parent directory of R/.}

\item{overwrite}{Overwrite if the test file you're trying to create already
exists?}

\item{e_e}{Set this to \code{FALSE} to prevent anything from being put in the
shell of a \code{\link[testthat:equality-expectations]{testthat::expect_equal()}} statement.}

\item{roxytest}{Copy \code{roxytest} package \verb{@testexamples} code to clipboard
instead of creating file in \code{tests/testthat}?}

\item{open}{Open the created test file in your editor after it is created?}

\item{document}{Run \code{\link[roxygen2:roxygenize]{roxygen2::roxygenize()}} to update package documentation
before starting?}

\item{r_file_name}{The name of the '.R' file within 'R/'. There's no need to
specify the file path (as 'R/x.R', but you can do this if you want), you
can just use 'x.R' for whichever file 'x' it is. You can also omit the '.R'
for convenience, however using the wrong case (e.g. '.r' when the file
actually has the extension '.R') will produce an error.}
}
\value{
The shell of the test file is written into tests/testthat. It has the
same name as the .R file it was created from except it has "test_" tacked
onto the front.
}
\description{
\itemize{\item For a given function \code{fun()} in a package,
\link[=make-test-shells]{make_test_shell_fun()} checks if there are examples for
that function detailed in the 'man/' directory (in a '.Rd' file) and if so
creates a shell (skeleton) of a \code{\link[testthat:test_that]{testthat::test_that()}} test based on those
examples. The created shell is then written to a corresponding file
'test-fun.R' (or if that already exists, 'test-fun-examples.R') in
'tests/testthat'. \item For a given file 'x.R' in the 'R/' directory of a
package, for each function defined in that '.R' file,
\link[=make-test-shells]{make_tests_shells_file()} checks if there are examples for
that function detailed in the 'man/' directory (in a '.Rd' file) and if so
creates a shell (skeleton) of a \code{\link[testthat:test_that]{testthat::test_that()}} test based on those
examples via \link[=make-test-shells]{make_test_shell()}. The created shells are
then written to a corresponding file 'test-x.R' (or  'test-x-examples.R' if
'test-x.R' is already taken) in 'tests/testthat'. \item
\link[=make-test-shells]{make_test_shells_pkg()} runs
\link[=make-test-shells]{make_test_shells_file()} on every '.R' file in the 'R/'
directory of a package.}
}
\examples{
\dontrun{
pkg_dir <- "~/mylilpkg"
usethis::create_package(pkg_dir, rstudio = FALSE, open = FALSE)
fs::file_copy(
  system.file("extdata", c("detect.R", "match.R"),
    package = "exampletestr"
  ),
  paste0(pkg_dir, "/R")
)
make_test_shell_fun("str_detect()", pkg_dir,
  document = TRUE, roxytest = TRUE
)
make_test_shell_fun("str_detect()", pkg_dir,
  document = TRUE, open = FALSE
)
make_tests_shells_file("detect", pkg_dir,
  document = FALSE, open = FALSE
)
make_tests_shells_pkg(pkg_dir,
  overwrite = TRUE, document = FALSE
)
fs::dir_delete(pkg_dir)
}

}
