% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch02TestItemAnalysis.R
\name{percentile}
\alias{percentile}
\title{Student Percentile Ranks}
\usage{
percentile(U, na = NULL, Z = NULL, w = NULL, ...)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{...}{Internal parameters for maintaining compatibility with the binary data
processing system. Not intended for direct use.}
}
\value{
A numeric vector of percentile ranks (1-100) for each student, where:
\itemize{
\item 100: Highest performing student(s)
\item 50: Median performance
\item 1: Lowest performing student(s)
}
}
\description{
The percentile function calculates each student's relative standing in the group,
expressed as a percentile rank (1-100). This function is applicable only to
binary response data.

The percentile rank indicates the percentage of scores in the distribution
that fall below a given score. For example, a percentile rank of 75 means
the student performed better than 75\% of the group.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.

Percentile ranks are calculated using the empirical cumulative distribution
function of standardized scores. Tied scores receive the same percentile rank.
The values are rounded up to the nearest integer to provide ranks from 1 to 100.
}
\examples{
# using sample dataset
percentile(J5S10)

}
